/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.resteasy.reactive.server.core.BlockingOperationSupport;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class VirtualThreadNonBlockingHandler
implements ServerRestHandler {
    private Executor executor;
    private static volatile ConcurrentHashMap<String, Executor> eventLoops = new ConcurrentHashMap();

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        if (BlockingOperationSupport.isBlockingAllowed()) {
            return;
        }
        if (!eventLoops.containsKey(Thread.currentThread().toString())) {
            Class<?> vtf = Class.forName("java.lang.ThreadBuilders").getDeclaredClasses()[0];
            Constructor<?> constructor = vtf.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            ThreadFactory tf = (ThreadFactory)constructor.newInstance(requestContext.getContextExecutor(), "quarkus-virtual-factory", 0, 0, null);
            Executor exec = (Executor)Executors.class.getMethod("newThreadPerTaskExecutor", ThreadFactory.class).invoke((Object)this, tf);
            eventLoops.put(Thread.currentThread().toString(), exec);
        }
        requestContext.suspend();
        requestContext.resume(eventLoops.get(Thread.currentThread().toString()));
    }
}

