/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tim.prune.App;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.FileType;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.SourceInfo;
import tim.prune.data.UnitSetLibrary;
import tim.prune.load.FileToBeLoaded;
import tim.prune.load.FileTypeLoader;
import tim.prune.load.NmeaMessage;

public class NmeaFileLoader
extends FileTypeLoader {
    public NmeaFileLoader(App app) {
        super(app);
    }

    public void openFile(FileToBeLoaded fileToBeLoaded, boolean bl) {
        ArrayList<NmeaMessage> arrayList;
        block24: {
            BufferedReader bufferedReader = null;
            arrayList = new ArrayList<NmeaMessage>();
            String string = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(fileToBeLoaded.getFile()));
                    String string2 = bufferedReader.readLine();
                    boolean bl2 = true;
                    while (string2 != null) {
                        if (string2.trim().length() > 0) {
                            NmeaMessage nmeaMessage = NmeaFileLoader.processGGA(string2);
                            if (nmeaMessage != null) {
                                if (nmeaMessage.hasFix()) {
                                    nmeaMessage.setSegment(bl2);
                                    nmeaMessage.setDate(string);
                                    arrayList.add(nmeaMessage);
                                }
                                bl2 = !nmeaMessage.hasFix();
                            } else {
                                String string3 = NmeaFileLoader.getDateFromRMC(string2);
                                if (string3 != null) {
                                    if (string == null && !arrayList.isEmpty()) {
                                        for (NmeaMessage nmeaMessage2 : arrayList) {
                                            nmeaMessage2.setDate(string3);
                                        }
                                    }
                                    string = string3;
                                }
                            }
                        }
                        string2 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    this.getApp().showErrorMessage("error.load.dialogtitle", "error.load.noread");
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block24;
                    }
                    catch (Exception exception) {}
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        if (arrayList.size() > 0) {
            int n = this.getAppendOption(bl);
            if (n == 2) {
                return;
            }
            this.loadData(this.makePointList(arrayList), new SourceInfo(fileToBeLoaded.getFile(), FileType.NMEA), n == 0);
        }
    }

    private static NmeaMessage processGGA(String string) {
        if (string == null || string.length() < 20 || !string.startsWith("$GPGGA")) {
            return null;
        }
        String[] stringArray = string.split(",");
        if (stringArray != null && stringArray.length >= 10) {
            return new NmeaMessage(String.valueOf(stringArray[2]) + stringArray[3], String.valueOf(stringArray[4]) + stringArray[5], stringArray[9], stringArray[1], stringArray[6]);
        }
        return null;
    }

    private static String getDateFromRMC(String string) {
        if (string == null || string.length() < 20 || !string.startsWith("$GPRMC")) {
            return null;
        }
        String[] stringArray = string.split(",");
        if (stringArray != null && stringArray.length >= 10) {
            return stringArray[9];
        }
        return null;
    }

    private List<DataPoint> makePointList(ArrayList<NmeaMessage> arrayList) {
        ArrayList<DataPoint> arrayList2 = new ArrayList<DataPoint>();
        for (NmeaMessage nmeaMessage : arrayList) {
            DataPoint dataPoint = new DataPoint(Latitude.make(nmeaMessage.getLatitude()), Longitude.make(nmeaMessage.getLongitude()), new Altitude(nmeaMessage.getAltitude(), UnitSetLibrary.UNITS_METRES));
            dataPoint.setSegmentStart(nmeaMessage.getSegmentFlag());
            arrayList2.add(dataPoint);
        }
        return arrayList2;
    }
}

