/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang.test;

import com.drew.lang.CompoundException;
import com.drew.lang.NullOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.TestCase;

public class CompoundExceptionTest
extends TestCase {
    public CompoundExceptionTest(String s) {
        super(s);
    }

    public void testUnnestedGetMessage() throws Exception {
        try {
            throw new CompoundException("message");
        }
        catch (CompoundException e) {
            CompoundExceptionTest.assertEquals((String)"message", (String)e.getMessage());
            return;
        }
    }

    public void testNestedGetMessage() throws Exception {
        try {
            try {
                throw new IOException("io");
            }
            catch (IOException e) {
                throw new CompoundException("compound", e);
            }
        }
        catch (CompoundException e) {
            CompoundExceptionTest.assertEquals((String)"compound", (String)e.getMessage());
            CompoundExceptionTest.assertEquals((String)"io", (String)e.getInnerException().getMessage());
            return;
        }
    }

    public void testNoInnerException() throws Exception {
        try {
            throw new CompoundException("message", null);
        }
        catch (CompoundException e) {
            try {
                PrintStream nullStream = new PrintStream(new NullOutputStream());
                e.printStackTrace(nullStream);
                e.printStackTrace(new PrintWriter(nullStream));
            }
            catch (Exception e1) {
                CompoundExceptionTest.fail((String)"Exception during printStackTrace for CompoundException with no inner exception");
            }
            return;
        }
    }
}

