/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import opennlp.tools.commons.Internal;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

@Internal
public class BioNLP2004NameSampleStream
implements ObjectStream<NameSample> {
    private static final String CODEC_TAG_O = "O";
    private static final String CODEC_TAG_B = "B-";
    private static final String CODEC_TAG_I = "I-";
    public static final int GENERATE_DNA_ENTITIES = 1;
    public static final int GENERATE_PROTEIN_ENTITIES = 2;
    public static final int GENERATE_CELLTYPE_ENTITIES = 4;
    public static final int GENERATE_CELLLINE_ENTITIES = 8;
    public static final int GENERATE_RNA_ENTITIES = 16;
    private final int types;
    private final ObjectStream<String> lineStream;

    public BioNLP2004NameSampleStream(InputStreamFactory in, int types) throws IOException {
        this.lineStream = new PlainTextByLineStream(in, StandardCharsets.UTF_8);
        this.types = types;
    }

    @Override
    public NameSample read() throws IOException {
        String line;
        ArrayList<String> sentence = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        boolean isClearAdaptiveData = false;
        while ((line = this.lineStream.read()) != null && !StringUtil.isEmpty(line.trim())) {
            if (line.startsWith("###MEDLINE:")) {
                isClearAdaptiveData = true;
                this.lineStream.read();
                continue;
            }
            if (line.contains("ABSTRACT TRUNCATED")) continue;
            String[] fields = line.split("\t");
            if (fields.length == 2) {
                sentence.add(fields[0]);
                tags.add(fields[1]);
                continue;
            }
            throw new IOException("Expected two fields per line in training data, got " + fields.length + " for line '" + line + "'!");
        }
        if (!sentence.isEmpty()) {
            ArrayList<Span> names = new ArrayList<Span>();
            int beginIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < tags.size(); ++i) {
                String tag = (String)tags.get(i);
                if (tag.endsWith("DNA") && (this.types & 1) == 0) {
                    tag = CODEC_TAG_O;
                }
                if (tag.endsWith("protein") && (this.types & 2) == 0) {
                    tag = CODEC_TAG_O;
                }
                if (tag.endsWith("cell_type") && (this.types & 4) == 0) {
                    tag = CODEC_TAG_O;
                }
                if (tag.endsWith("cell_line") && (this.types & 4) == 0) {
                    tag = CODEC_TAG_O;
                }
                if (tag.endsWith("RNA") && (this.types & 0x10) == 0) {
                    tag = CODEC_TAG_O;
                }
                if (tag.startsWith(CODEC_TAG_B)) {
                    if (beginIndex != -1) {
                        names.add(new Span(beginIndex, endIndex, ((String)tags.get(beginIndex)).substring(2)));
                    }
                    beginIndex = i;
                    endIndex = i + 1;
                    continue;
                }
                if (tag.startsWith(CODEC_TAG_I)) {
                    ++endIndex;
                    continue;
                }
                if (tag.equals(CODEC_TAG_O)) {
                    if (beginIndex == -1) continue;
                    names.add(new Span(beginIndex, endIndex, ((String)tags.get(beginIndex)).substring(2)));
                    beginIndex = -1;
                    endIndex = -1;
                    continue;
                }
                throw new IOException("Invalid tag: " + tag);
            }
            if (beginIndex != -1) {
                names.add(new Span(beginIndex, endIndex, ((String)tags.get(beginIndex)).substring(2)));
            }
            return new NameSample(sentence.toArray(new String[0]), names.toArray(new Span[0]), isClearAdaptiveData);
        }
        if (line != null) {
            return this.read();
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }
}

