/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.properties;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import net.infonode.docking.DefaultButtonFactories;
import net.infonode.docking.action.CloseWithAbortWindowAction;
import net.infonode.docking.action.DockWithAbortWindowAction;
import net.infonode.docking.action.MaximizeWithAbortWindowAction;
import net.infonode.docking.action.MinimizeWithAbortWindowAction;
import net.infonode.docking.action.RestoreViewWithAbortTitleBarAction;
import net.infonode.docking.action.RestoreWithAbortWindowAction;
import net.infonode.docking.action.UndockWithAbortWindowAction;
import net.infonode.docking.drop.AcceptAllDropFilter;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.docking.properties.FloatingWindowProperties;
import net.infonode.docking.properties.SplitWindowProperties;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.docking.properties.ViewProperties;
import net.infonode.docking.properties.ViewTitleBarProperties;
import net.infonode.docking.properties.ViewTitleBarStateProperties;
import net.infonode.docking.properties.WindowBarProperties;
import net.infonode.docking.properties.WindowTabButtonProperties;
import net.infonode.docking.properties.WindowTabProperties;
import net.infonode.docking.properties.WindowTabStateProperties;
import net.infonode.gui.DynamicUIManager;
import net.infonode.gui.DynamicUIManagerListener;
import net.infonode.gui.UIManagerUtil;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.componentpainter.AbstractComponentPainter;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.gui.componentpainter.SolidColorComponentPainter;
import net.infonode.properties.base.Property;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapContainer;
import net.infonode.properties.propertymap.PropertyMapFactory;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.properties.propertymap.PropertyMapProperty;
import net.infonode.properties.propertymap.PropertyMapValueHandler;
import net.infonode.properties.types.BooleanProperty;
import net.infonode.properties.types.IntegerProperty;
import net.infonode.tabbedpanel.TabAreaVisiblePolicy;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicy;
import net.infonode.tabbedpanel.TabSelectTrigger;
import net.infonode.tabbedpanel.TabbedPanelButtonProperties;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUIDefaults;
import net.infonode.tabbedpanel.border.TabAreaLineBorder;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.util.Direction;

public class RootWindowProperties
extends PropertyMapContainer {
    public static final int DEFAULT_WINDOW_TAB_BUTTON_ICON_SIZE = 10;
    public static final PropertyMapGroup PROPERTIES = new PropertyMapGroup("Root Window Properties", "");
    public static final PropertyMapProperty COMPONENT_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Component Properties", "The root window component property values.", ComponentProperties.PROPERTIES);
    public static final PropertyMapProperty SHAPED_PANEL_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Shaped Panel Properties", "The root window shaped panel property values.", ShapedPanelProperties.PROPERTIES);
    public static final PropertyMapProperty WINDOW_AREA_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Window Area Properties", "The window area component property values. The window area is the area inside the WindowBars.", ComponentProperties.PROPERTIES);
    public static final PropertyMapProperty WINDOW_AREA_SHAPED_PANEL_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Window Area Shaped Panel Properties", "The window area shaped panel property values. The window area is the area inside the WindowBars.", ShapedPanelProperties.PROPERTIES);
    public static final PropertyMapProperty DRAG_RECTANGLE_SHAPED_PANEL_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Drag Rectangle Shaped Panel Properties", "Shaped panel properties for the drag rectangle. Setting a painter disables the default drag rectangle.", ShapedPanelProperties.PROPERTIES);
    public static final IntegerProperty DRAG_RECTANGLE_BORDER_WIDTH = IntegerProperty.createPositive(PROPERTIES, "Drag Rectangle Border Width", "The width of the drag rectangle border. The drag rectangle will only be painted if the painter of the '" + DRAG_RECTANGLE_SHAPED_PANEL_PROPERTIES.getName() + "' property is not set.", 2, PropertyMapValueHandler.INSTANCE);
    public static final PropertyMapProperty DRAG_LABEL_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Drag Label Properties", "The window drag label property values.", ComponentProperties.PROPERTIES);
    public static final PropertyMapProperty DOCKING_WINDOW_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Docking Window Properties", "Default property values for DockingWindows inside this RootWindow.", DockingWindowProperties.PROPERTIES);
    public static final PropertyMapProperty TAB_WINDOW_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Tab Window Properties", "Default property values for TabWindows inside this RootWindow.", TabWindowProperties.PROPERTIES);
    public static final PropertyMapProperty SPLIT_WINDOW_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Split Window Properties", "Default property values for SplitWindows inside this RootWindow.", SplitWindowProperties.PROPERTIES);
    public static final PropertyMapProperty FLOATING_WINDOW_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Floating Window Properties", "Default property values for FloatingWindows inside this RootWindow.", FloatingWindowProperties.PROPERTIES);
    public static final PropertyMapProperty VIEW_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "View Properties", "Default property values for Views inside this RootWindow.", ViewProperties.PROPERTIES);
    public static final BooleanProperty DOUBLE_CLICK_RESTORES_WINDOW = new BooleanProperty((PropertyGroup)PROPERTIES, "Double Click Restores Window", "Double clicking on a minimized window in a window bar restores it.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty RECURSIVE_TABS_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Recursive Tabs Enabled", "If true, makes it possible for the user to create tab windows inside other tab windows by dragging windows. If false, only one level of tab windows is allowed. Changing the value of this property does not alter the window tree.", PropertyMapValueHandler.INSTANCE);
    public static final IntegerProperty EDGE_SPLIT_DISTANCE = IntegerProperty.createPositive(PROPERTIES, "Edge Split Distance", "Inside this distance from the window edge a mouse drag will trigger a window split.", 3, PropertyMapValueHandler.INSTANCE);
    public static final IntegerProperty ABORT_DRAG_KEY = IntegerProperty.createPositive(PROPERTIES, "Abort Drag Key Code", "Key code for the key that aborts a drag.", 3, PropertyMapValueHandler.INSTANCE);
    public static final PropertyMapProperty WINDOW_BAR_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Window Bar Properties", "Default property values for WindowBars inside this RootWindow.", WindowBarProperties.PROPERTIES);
    private static RootWindowProperties DEFAULT_VALUES = new RootWindowProperties(PROPERTIES.getDefaultMap());

    static {
        DEFAULT_VALUES.setAbortDragKey(TabbedPanelProperties.getDefaultProperties().getAbortDragKey()).setEdgeSplitDistance(6).setDragRectangleBorderWidth(5);
        DEFAULT_VALUES.getShapedPanelProperties().setOpaque(true);
        DEFAULT_VALUES.getDockingWindowProperties().setMaximizeEnabled(true).setMinimizeEnabled(true).setCloseEnabled(true).setRestoreEnabled(true).setDragEnabled(true).setUndockEnabled(true).setUndockOnDropEnabled(true).setDockEnabled(true);
        DEFAULT_VALUES.getDockingWindowProperties().getDropFilterProperties().setChildDropFilter(AcceptAllDropFilter.INSTANCE).setInsertTabDropFilter(AcceptAllDropFilter.INSTANCE).setInteriorDropFilter(AcceptAllDropFilter.INSTANCE).setSplitDropFilter(AcceptAllDropFilter.INSTANCE);
        DEFAULT_VALUES.getWindowAreaProperties().setInsets(new Insets(6, 6, 2, 2));
        DEFAULT_VALUES.getDragLabelProperties().setInsets(new Insets(4, 6, 4, 6));
        DEFAULT_VALUES.getDragRectangleShapedPanelProperties().setOpaque(false);
        DEFAULT_VALUES.getSplitWindowProperties().setContinuousLayoutEnabled(true).setDividerSize(4).setDividerLocationDragEnabled(true).setDragIndicatorColor(Color.DARK_GRAY);
        DEFAULT_VALUES.getViewProperties().setAlwaysShowTitle(true);
        RootWindowProperties.setTabbedPanelProperties();
        RootWindowProperties.setTabProperties();
        RootWindowProperties.setWindowBarProperties();
        RootWindowProperties.setViewTitleBarProperties();
        RootWindowProperties.setFloatingWindowProperties();
        RootWindowProperties.updateVisualProperties();
        RootWindowProperties.updateViewTitleBarProperties();
        RootWindowProperties.updateFont();
        TitledTabProperties.getDefaultProperties().getHighlightedProperties().getComponentProperties().getMap().addListener(new PropertyMapListener(){

            @Override
            public void propertyValuesChanged(PropertyMap propertyObject, Map changes) {
                RootWindowProperties.updateFont();
            }
        });
        DynamicUIManager.getInstance().addListener(new DynamicUIManagerListener(){

            @Override
            public void lookAndFeelChanged() {
                PropertyMapManager.runBatch(new Runnable(){

                    @Override
                    public void run() {
                        RootWindowProperties.updateVisualProperties();
                        RootWindowProperties.updateViewTitleBarProperties();
                    }
                });
            }

            @Override
            public void propertiesChanged() {
                PropertyMapManager.runBatch(new Runnable(){

                    @Override
                    public void run() {
                        RootWindowProperties.updateVisualProperties();
                        RootWindowProperties.updateViewTitleBarProperties();
                    }
                });
            }

            @Override
            public void propertiesChanging() {
            }

            @Override
            public void lookAndFeelChanging() {
            }
        });
    }

    private static void setTabProperties() {
        WindowTabProperties tabProperties = DEFAULT_VALUES.getTabWindowProperties().getTabProperties();
        PropertyMapProperty[] buttonProperties = new PropertyMapProperty[]{WindowTabStateProperties.CLOSE_BUTTON_PROPERTIES, WindowTabStateProperties.MINIMIZE_BUTTON_PROPERTIES, WindowTabStateProperties.RESTORE_BUTTON_PROPERTIES, WindowTabStateProperties.UNDOCK_BUTTON_PROPERTIES, WindowTabStateProperties.DOCK_BUTTON_PROPERTIES};
        int i = 0;
        while (i < buttonProperties.length) {
            int j = 0;
            while (j < WindowTabButtonProperties.PROPERTIES.getPropertyCount()) {
                Property property = WindowTabButtonProperties.PROPERTIES.getProperty(j);
                buttonProperties[i].get(tabProperties.getHighlightedButtonProperties().getMap()).createRelativeRef(property, buttonProperties[i].get(tabProperties.getNormalButtonProperties().getMap()), property);
                buttonProperties[i].get(tabProperties.getFocusedButtonProperties().getMap()).createRelativeRef(property, buttonProperties[i].get(tabProperties.getHighlightedButtonProperties().getMap()), property);
                ++j;
            }
            ++i;
        }
        tabProperties.getTitledTabProperties().getNormalProperties().setToolTipEnabled(true).getComponentProperties().setInsets(new Insets(0, 3, 0, 2));
        tabProperties.getTitledTabProperties().setSizePolicy(TitledTabSizePolicy.INDIVIDUAL_SIZE);
        tabProperties.getNormalButtonProperties().getCloseButtonProperties().setFactory(DefaultButtonFactories.getCloseButtonFactory()).setTo(CloseWithAbortWindowAction.INSTANCE);
        tabProperties.getNormalButtonProperties().getUndockButtonProperties().setFactory(DefaultButtonFactories.getUndockButtonFactory()).setVisible(false).setTo(UndockWithAbortWindowAction.INSTANCE);
        tabProperties.getNormalButtonProperties().getDockButtonProperties().setFactory(DefaultButtonFactories.getDockButtonFactory()).setVisible(false).setTo(DockWithAbortWindowAction.INSTANCE);
        tabProperties.getNormalButtonProperties().getRestoreButtonProperties().setFactory(DefaultButtonFactories.getRestoreButtonFactory()).setVisible(false).setTo(RestoreWithAbortWindowAction.INSTANCE);
        tabProperties.getNormalButtonProperties().getMinimizeButtonProperties().setFactory(DefaultButtonFactories.getMinimizeButtonFactory()).setVisible(false).setTo(MinimizeWithAbortWindowAction.INSTANCE);
        tabProperties.getTitledTabProperties().setFocusable(false);
        tabProperties.getHighlightedButtonProperties().getCloseButtonProperties().setVisible(true);
        tabProperties.getHighlightedButtonProperties().getMinimizeButtonProperties().setVisible(true);
        tabProperties.getHighlightedButtonProperties().getRestoreButtonProperties().setVisible(true);
        tabProperties.getHighlightedButtonProperties().getUndockButtonProperties().setVisible(true);
        tabProperties.getHighlightedButtonProperties().getDockButtonProperties().setVisible(true);
    }

    private static void setTabbedPanelProperties() {
        TabWindowProperties tabWindowProperties = DEFAULT_VALUES.getTabWindowProperties();
        tabWindowProperties.getTabbedPanelProperties().setTabDropDownListVisiblePolicy(TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE).setTabSelectTrigger(TabSelectTrigger.MOUSE_RELEASE).setEnsureSelectedTabVisible(true).setTabReorderEnabled(false).setHighlightPressedTab(false).setShadowEnabled(true);
        tabWindowProperties.getTabbedPanelProperties().getTabAreaComponentsProperties().getComponentProperties().setInsets(new Insets(1, 3, 1, 3));
        tabWindowProperties.getCloseButtonProperties().setFactory(DefaultButtonFactories.getCloseButtonFactory()).setVisible(true).setTo(CloseWithAbortWindowAction.INSTANCE);
        tabWindowProperties.getRestoreButtonProperties().setFactory(DefaultButtonFactories.getRestoreButtonFactory()).setVisible(true).setTo(RestoreWithAbortWindowAction.INSTANCE);
        tabWindowProperties.getMinimizeButtonProperties().setFactory(DefaultButtonFactories.getMinimizeButtonFactory()).setVisible(true).setTo(MinimizeWithAbortWindowAction.INSTANCE);
        tabWindowProperties.getMaximizeButtonProperties().setFactory(DefaultButtonFactories.getMaximizeButtonFactory()).setVisible(true).setTo(MaximizeWithAbortWindowAction.INSTANCE);
        tabWindowProperties.getUndockButtonProperties().setFactory(DefaultButtonFactories.getUndockButtonFactory()).setVisible(true).setTo(UndockWithAbortWindowAction.INSTANCE);
        tabWindowProperties.getDockButtonProperties().setFactory(DefaultButtonFactories.getDockButtonFactory()).setVisible(true).setTo(DockWithAbortWindowAction.INSTANCE);
        TabbedPanelButtonProperties buttonProps = tabWindowProperties.getTabbedPanelProperties().getButtonProperties();
        buttonProps.getTabDropDownListButtonProperties().setToolTipText("Tab List");
        buttonProps.getScrollLeftButtonProperties().setToolTipText("Scroll Left");
        buttonProps.getScrollRightButtonProperties().setToolTipText("Scroll Right");
        buttonProps.getScrollUpButtonProperties().setToolTipText("Scroll Up");
        buttonProps.getScrollDownButtonProperties().setToolTipText("Scroll Down");
    }

    private static void setWindowBarProperties() {
        PropertyMapContainer p = DEFAULT_VALUES.getWindowBarProperties();
        ((WindowBarProperties)p).setMinimumWidth(4);
        ((WindowBarProperties)p).setContentPanelEdgeResizeEdgeDistance(6);
        ((WindowBarProperties)p).setContinuousLayoutEnabled(true);
        ((WindowBarProperties)p).setDragIndicatorColor(Color.DARK_GRAY);
        ((WindowBarProperties)p).getTabWindowProperties().getTabbedPanelProperties().setTabDeselectable(true).setAutoSelectTab(false).getTabAreaComponentsProperties().setStretchEnabled(true).getComponentProperties().setBorder(new TabAreaLineBorder());
        ((WindowBarProperties)p).getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getComponentProperties().setInsets(new Insets(4, 4, 4, 4));
        ((WindowBarProperties)p).getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getShapedPanelProperties().setOpaque(true);
        ((WindowBarProperties)p).getTabWindowProperties().getTabbedPanelProperties().getTabAreaProperties().setTabAreaVisiblePolicy(TabAreaVisiblePolicy.ALWAYS);
        p = DEFAULT_VALUES.getWindowBarProperties().getTabWindowProperties().getTabProperties();
        ((WindowTabProperties)p).getTitledTabProperties().setSizePolicy(TitledTabSizePolicy.EQUAL_SIZE).setHighlightedRaised(0);
        ((WindowTabProperties)p).getTitledTabProperties().getNormalProperties().getComponentProperties().setInsets(new Insets(1, 4, 1, 4));
        ((WindowTabProperties)p).getNormalButtonProperties().getCloseButtonProperties().setVisible(true);
        ((WindowTabProperties)p).getNormalButtonProperties().getRestoreButtonProperties().setVisible(true);
        ((WindowTabProperties)p).getNormalButtonProperties().getUndockButtonProperties().setVisible(true);
        ((WindowTabProperties)p).getNormalButtonProperties().getDockButtonProperties().setVisible(true);
    }

    private static void setFloatingWindowProperties() {
        Property property;
        int i = 0;
        while (i < ComponentProperties.PROPERTIES.getPropertyCount()) {
            property = ComponentProperties.PROPERTIES.getProperty(i);
            FloatingWindowProperties.COMPONENT_PROPERTIES.get(DEFAULT_VALUES.getFloatingWindowProperties().getMap()).createRelativeRef(property, WINDOW_AREA_PROPERTIES.get(DEFAULT_VALUES.getMap()), property);
            ++i;
        }
        i = 0;
        while (i < ShapedPanelProperties.PROPERTIES.getPropertyCount()) {
            property = ShapedPanelProperties.PROPERTIES.getProperty(i);
            FloatingWindowProperties.SHAPED_PANEL_PROPERTIES.get(DEFAULT_VALUES.getFloatingWindowProperties().getMap()).createRelativeRef(property, WINDOW_AREA_SHAPED_PANEL_PROPERTIES.get(DEFAULT_VALUES.getMap()), property);
            ++i;
        }
        DEFAULT_VALUES.getFloatingWindowProperties().setAutoCloseEnabled(true);
        DEFAULT_VALUES.getFloatingWindowProperties().setUseFrame(false);
    }

    private static void setViewTitleBarProperties() {
        ViewTitleBarProperties props = DEFAULT_VALUES.getViewProperties().getViewTitleBarProperties();
        props.setOrientation(Direction.UP).setDirection(Direction.RIGHT).getNormalProperties().setTitleVisible(true).setIconVisible(true);
        ViewTitleBarStateProperties stateProps = props.getNormalProperties();
        stateProps.setButtonSpacing(0);
        stateProps.getUndockButtonProperties().setFactory(DefaultButtonFactories.getUndockButtonFactory()).setVisible(true).setTo(UndockWithAbortWindowAction.INSTANCE);
        stateProps.getDockButtonProperties().setFactory(DefaultButtonFactories.getDockButtonFactory()).setVisible(true).setTo(DockWithAbortWindowAction.INSTANCE);
        stateProps.getCloseButtonProperties().setFactory(DefaultButtonFactories.getCloseButtonFactory()).setVisible(true).setTo(CloseWithAbortWindowAction.INSTANCE);
        stateProps.getRestoreButtonProperties().setFactory(DefaultButtonFactories.getRestoreButtonFactory()).setVisible(true).setTo(RestoreViewWithAbortTitleBarAction.INSTANCE);
        stateProps.getMinimizeButtonProperties().setFactory(DefaultButtonFactories.getMinimizeButtonFactory()).setVisible(true).setTo(MinimizeWithAbortWindowAction.INSTANCE);
        stateProps.getMaximizeButtonProperties().setFactory(DefaultButtonFactories.getMaximizeButtonFactory()).setVisible(true).setTo(MaximizeWithAbortWindowAction.INSTANCE);
        stateProps.getMap().createRelativeRef(ViewTitleBarStateProperties.TITLE, DEFAULT_VALUES.getViewProperties().getMap(), ViewProperties.TITLE);
        stateProps.getMap().createRelativeRef(ViewTitleBarStateProperties.ICON, DEFAULT_VALUES.getViewProperties().getMap(), ViewProperties.ICON);
    }

    private static void updateVisualProperties() {
        DEFAULT_VALUES.getWindowBarProperties().getTabWindowProperties().getTabProperties().getTitledTabProperties().getNormalProperties().getComponentProperties().setBackgroundColor(TabbedUIDefaults.getHighlightedStateBackground());
        Color shadowColor = UIManagerUtil.getColor("controlDkShadow", Color.BLACK);
        DEFAULT_VALUES.getWindowAreaProperties().setBorder(new LineBorder(shadowColor)).setBackgroundColor(UIManagerUtil.getColor("Desktop.background", "control"));
        DEFAULT_VALUES.getWindowAreaShapedPanelProperties().setOpaque(true);
        DEFAULT_VALUES.getDragLabelProperties().setBorder(new LineBorder(shadowColor)).setFont(UIManagerUtil.getFont("ToolTip.font")).setForegroundColor(UIManagerUtil.getColor("ToolTip.foreground", "controlText")).setBackgroundColor(UIManagerUtil.getColor("ToolTip.background", "control"));
        DEFAULT_VALUES.setRecursiveTabsEnabled(true);
    }

    private static void updateFont() {
        Font font = TitledTabProperties.getDefaultProperties().getHighlightedProperties().getComponentProperties().getFont();
        if (font != null) {
            font = font.deriveFont(1);
        }
        DEFAULT_VALUES.getTabWindowProperties().getTabProperties().getTitledTabProperties().getHighlightedProperties().getComponentProperties().setFont(font);
    }

    private static void updateViewTitleBarProperties() {
        ViewTitleBarProperties props = DEFAULT_VALUES.getViewProperties().getViewTitleBarProperties();
        Font font = TabbedUIDefaults.getFont();
        if (font != null) {
            font = font.deriveFont(1);
        }
        props.getNormalProperties().getComponentProperties().setFont(font).setForegroundColor(UIManager.getColor("InternalFrame.inactiveTitleForeground")).setBackgroundColor(UIManager.getColor("InternalFrame.inactiveTitleBackground")).setInsets(new Insets(2, 2, 2, 2));
        props.getFocusedProperties().getComponentProperties().setForegroundColor(UIManager.getColor("InternalFrame.activeTitleForeground")).setBackgroundColor(UIManager.getColor("InternalFrame.activeTitleBackground"));
        Color c1 = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        Color c2 = UIManager.getColor("InternalFrame.inactiveTitleGradient");
        AbstractComponentPainter backgroundPainter = c1 == null ? null : (c1.equals(c2) || c2 == null ? new SolidColorComponentPainter(new FixedColorProvider(c1)) : new GradientComponentPainter(c2, c2, c1, c1));
        props.getNormalProperties().getShapedPanelProperties().setComponentPainter(backgroundPainter).setOpaque(true);
        Color focused1 = UIManager.getColor("InternalFrame.activeTitleBackground");
        Color focused2 = UIManager.getColor("InternalFrame.activeTitleGradient");
        AbstractComponentPainter focusedPainter = focused1 == null ? null : (focused1.equals(focused2) || focused2 == null ? new SolidColorComponentPainter(new FixedColorProvider(focused1)) : new GradientComponentPainter(focused2, focused2, focused1, focused1));
        props.getFocusedProperties().getShapedPanelProperties().setComponentPainter(focusedPainter);
        props.getFocusedProperties().getComponentProperties().setForegroundColor(UIManager.getColor("InternalFrame.activeTitleForeground"));
        props.setContentTitleBarGap(0).getNormalProperties().setIconTextGap(TabbedUIDefaults.getIconTextGap());
    }

    public static RootWindowProperties createDefault() {
        return new RootWindowProperties(DEFAULT_VALUES);
    }

    public RootWindowProperties() {
        super(PropertyMapFactory.create(PROPERTIES));
    }

    public RootWindowProperties(PropertyMap map) {
        super(map);
    }

    public RootWindowProperties(RootWindowProperties inheritFrom) {
        super(PropertyMapFactory.create(inheritFrom.getMap()));
    }

    public RootWindowProperties addSuperObject(RootWindowProperties properties) {
        this.getMap().addSuperMap(properties.getMap());
        return this;
    }

    public RootWindowProperties removeSuperObject() {
        this.getMap().removeSuperMap();
        return this;
    }

    public RootWindowProperties removeSuperObject(RootWindowProperties superObject) {
        this.getMap().removeSuperMap(superObject.getMap());
        return this;
    }

    public RootWindowProperties replaceSuperObject(RootWindowProperties oldSuperObject, RootWindowProperties newSuperObject) {
        this.getMap().replaceSuperMap(oldSuperObject.getMap(), newSuperObject.getMap());
        return this;
    }

    public TabWindowProperties getTabWindowProperties() {
        return new TabWindowProperties(TAB_WINDOW_PROPERTIES.get(this.getMap()));
    }

    public SplitWindowProperties getSplitWindowProperties() {
        return new SplitWindowProperties(SPLIT_WINDOW_PROPERTIES.get(this.getMap()));
    }

    public FloatingWindowProperties getFloatingWindowProperties() {
        return new FloatingWindowProperties(FLOATING_WINDOW_PROPERTIES.get(this.getMap()));
    }

    public ViewProperties getViewProperties() {
        return new ViewProperties(VIEW_PROPERTIES.get(this.getMap()));
    }

    public DockingWindowProperties getDockingWindowProperties() {
        return new DockingWindowProperties(DOCKING_WINDOW_PROPERTIES.get(this.getMap()));
    }

    public RootWindowProperties setDragRectangleBorderWidth(int width) {
        DRAG_RECTANGLE_BORDER_WIDTH.set(this.getMap(), width);
        return this;
    }

    public int getDragRectangleBorderWidth() {
        return DRAG_RECTANGLE_BORDER_WIDTH.get(this.getMap());
    }

    public boolean getRecursiveTabsEnabled() {
        return RECURSIVE_TABS_ENABLED.get(this.getMap());
    }

    public boolean getDoubleClickRestoresWindow() {
        return DOUBLE_CLICK_RESTORES_WINDOW.get(this.getMap());
    }

    public RootWindowProperties setDoubleClickRestoresWindow(boolean enabled) {
        DOUBLE_CLICK_RESTORES_WINDOW.set(this.getMap(), enabled);
        return this;
    }

    public RootWindowProperties setRecursiveTabsEnabled(boolean enabled) {
        RECURSIVE_TABS_ENABLED.set(this.getMap(), enabled);
        return this;
    }

    public ComponentProperties getDragLabelProperties() {
        return new ComponentProperties(DRAG_LABEL_PROPERTIES.get(this.getMap()));
    }

    public ComponentProperties getComponentProperties() {
        return new ComponentProperties(COMPONENT_PROPERTIES.get(this.getMap()));
    }

    public ShapedPanelProperties getShapedPanelProperties() {
        return new ShapedPanelProperties(SHAPED_PANEL_PROPERTIES.get(this.getMap()));
    }

    public ComponentProperties getWindowAreaProperties() {
        return new ComponentProperties(WINDOW_AREA_PROPERTIES.get(this.getMap()));
    }

    public ShapedPanelProperties getWindowAreaShapedPanelProperties() {
        return new ShapedPanelProperties(WINDOW_AREA_SHAPED_PANEL_PROPERTIES.get(this.getMap()));
    }

    public RootWindowProperties setEdgeSplitDistance(int size) {
        EDGE_SPLIT_DISTANCE.set(this.getMap(), size);
        return this;
    }

    public int getEdgeSplitDistance() {
        return EDGE_SPLIT_DISTANCE.get(this.getMap());
    }

    public int getAbortDragKey() {
        return ABORT_DRAG_KEY.get(this.getMap());
    }

    public RootWindowProperties setAbortDragKey(int key) {
        ABORT_DRAG_KEY.set(this.getMap(), key);
        return this;
    }

    public WindowBarProperties getWindowBarProperties() {
        return new WindowBarProperties(WINDOW_BAR_PROPERTIES.get(this.getMap()));
    }

    public ShapedPanelProperties getDragRectangleShapedPanelProperties() {
        return new ShapedPanelProperties(DRAG_RECTANGLE_SHAPED_PANEL_PROPERTIES.get(this.getMap()));
    }
}

