/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.plugin.event;

import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.TimeStampedEvent;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class SnippetsSuggestedEvent
extends TimeStampedEvent {
    private final URI uri;
    private final Location testCaseLocation;
    private final Location stepLocation;
    private final Suggestion suggestion;

    @Deprecated
    public SnippetsSuggestedEvent(Instant timeInstant, URI uri, int scenarioLine, int stepLine, List<String> snippets) {
        this(timeInstant, uri, new Location(scenarioLine, -1), new Location(stepLine, -1), snippets);
    }

    @Deprecated
    public SnippetsSuggestedEvent(Instant instant, URI uri, Location testCaseLocation, Location stepLocation, List<String> snippets) {
        this(instant, uri, testCaseLocation, stepLocation, new Suggestion("", snippets));
    }

    public SnippetsSuggestedEvent(Instant instant, URI uri, Location testCaseLocation, Location stepLocation, Suggestion suggestion) {
        super(instant);
        this.uri = Objects.requireNonNull(uri);
        this.testCaseLocation = Objects.requireNonNull(testCaseLocation);
        this.stepLocation = Objects.requireNonNull(stepLocation);
        this.suggestion = Objects.requireNonNull(suggestion);
    }

    public URI getUri() {
        return this.uri;
    }

    @Deprecated
    public int getStepLine() {
        return this.stepLocation.getLine();
    }

    @Deprecated
    public int getScenarioLine() {
        return this.testCaseLocation.getLine();
    }

    @Deprecated
    public Location getScenarioLocation() {
        return this.testCaseLocation;
    }

    public Location getTestCaseLocation() {
        return this.testCaseLocation;
    }

    public Location getStepLocation() {
        return this.stepLocation;
    }

    @Deprecated
    public List<String> getSnippets() {
        return this.suggestion.getSnippets();
    }

    public Suggestion getSuggestion() {
        return this.suggestion;
    }

    public static final class Suggestion {
        final String step;
        final List<String> snippets;

        public Suggestion(String step, List<String> snippets) {
            this.step = Objects.requireNonNull(step);
            this.snippets = Collections.unmodifiableList(Objects.requireNonNull(snippets));
        }

        public String getStep() {
            return this.step;
        }

        public List<String> getSnippets() {
            return this.snippets;
        }
    }
}

