/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverSelectViewer;

public class MigrateConnectionWizard
extends Wizard {
    private final DBPDataSourceRegistry registry;
    private final Set<DBPDataSourceContainer> selectedConnections = new HashSet<DBPDataSourceContainer>();
    private PageConnections pageConnections;
    private PageDriver pageDriver;

    public MigrateConnectionWizard(DBPDataSourceRegistry registry, IStructuredSelection selection) {
        this.registry = registry;
        if (selection != null && !selection.isEmpty()) {
            for (Object item : selection) {
                if (item instanceof DBPDataSourceContainerProvider) {
                    this.selectedConnections.add(((DBPDataSourceContainerProvider)item).getDataSourceContainer());
                    continue;
                }
                if (item instanceof DBPDataSourceContainer) {
                    this.selectedConnections.add((DBPDataSourceContainer)item);
                    continue;
                }
                if (item instanceof DBSObject) {
                    this.selectedConnections.add(((DBSObject)item).getDataSource().getContainer());
                    continue;
                }
                if (!(item instanceof DBSWrapper)) continue;
                this.selectedConnections.add(((DBSWrapper)item).getObject().getDataSource().getContainer());
            }
        }
        this.setWindowTitle(CoreMessages.dialog_migrate_wizard_window_title);
    }

    public void addPages() {
        this.pageConnections = new PageConnections();
        this.pageDriver = new PageDriver(this);
        this.addPage((IWizardPage)this.pageConnections);
        this.addPage((IWizardPage)this.pageDriver);
    }

    public IWizardPage getStartingPage() {
        if (!this.selectedConnections.isEmpty()) {
            return this.pageDriver;
        }
        return this.pageConnections;
    }

    public boolean performFinish() {
        boolean isReconnect;
        List<DataSourceDescriptor> connections = this.pageConnections.getSelectedConnections();
        DriverDescriptor targetDriver = this.pageDriver.selectedDriver;
        ArrayList<DataSourceDescriptor> changedConnections = new ArrayList<DataSourceDescriptor>();
        for (DataSourceDescriptor conn : connections) {
            if (!conn.getDriver().equals((Object)targetDriver)) {
                changedConnections.add(conn);
            }
            conn.setDriver(targetDriver);
            conn.persistConfiguration();
        }
        if (!changedConnections.isEmpty() && (isReconnect = UIUtils.confirmAction((Shell)UIUtils.getActiveWorkbenchShell(), (String)CoreMessages.dialog_migrate_wizard_connection_changed_title, (String)NLS.bind((String)CoreMessages.dialog_migrate_wizard_connection_changed_message, (Object)changedConnections.size())))) {
            changedConnections.forEach(c -> DataSourceHandler.reconnectDataSource(null, (DBPDataSourceContainer)c));
        }
        return true;
    }

    class PageConnections
    extends WizardPage {
        private Table connectionsViewer;

        protected PageConnections() {
            super(CoreMessages.dialog_migrate_wizard_name);
            this.setTitle(CoreMessages.dialog_migrate_wizard_start_title);
            this.setDescription(CoreMessages.dialog_migrate_wizard_start_description);
        }

        public void createControl(Composite parent) {
            Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
            this.connectionsViewer = new Table(composite, 67618);
            this.connectionsViewer.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PageConnections.this.getContainer().updateButtons();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    PageConnections.this.getContainer().showPage(PageConnections.this.getNextPage());
                }
            });
            GridData gd = new GridData(1808);
            gd.widthHint = 400;
            gd.heightHint = 400;
            this.connectionsViewer.setLayoutData((Object)gd);
            if (MigrateConnectionWizard.this.registry != null) {
                for (DBPDataSourceContainer ds : MigrateConnectionWizard.this.registry.getDataSources()) {
                    TableItem item = new TableItem(this.connectionsViewer, 0);
                    item.setText(ds.getName());
                    item.setData((Object)ds);
                    item.setImage(DBeaverIcons.getImage((DBPImage)ds.getDriver().getIcon()));
                    if (!MigrateConnectionWizard.this.selectedConnections.contains(ds)) continue;
                    item.setChecked(true);
                }
            }
            this.setControl((Control)composite);
        }

        public boolean isPageComplete() {
            for (TableItem item : this.connectionsViewer.getItems()) {
                if (!item.getChecked()) continue;
                return true;
            }
            return false;
        }

        public List<DataSourceDescriptor> getSelectedConnections() {
            ArrayList<DataSourceDescriptor> result = new ArrayList<DataSourceDescriptor>();
            for (TableItem item : this.connectionsViewer.getItems()) {
                if (!item.getChecked()) continue;
                result.add((DataSourceDescriptor)item.getData());
            }
            return result;
        }
    }

    class PageDriver
    extends WizardPage
    implements ISelectionChangedListener {
        private DriverDescriptor selectedDriver;
        private DriverSelectViewer driverSelectViewer;

        PageDriver(MigrateConnectionWizard this$0) {
            super("migrateConnectionDriver");
            this.setTitle(CoreMessages.dialog_migrate_wizard_choose_driver_title);
            this.setDescription(CoreMessages.dialog_migrate_wizard_choose_driver_description);
        }

        public void createControl(Composite parent) {
            Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
            Dialog.applyDialogFont((Control)placeholder);
            this.driverSelectViewer = new DriverSelectViewer(placeholder, (Object)this, DataSourceProviderRegistry.getInstance().getEnabledDataSourceProviders(), true);
            GridData gd = new GridData(1808);
            gd.heightHint = 200;
            this.driverSelectViewer.getControl().setLayoutData((Object)gd);
            this.setControl((Control)placeholder);
        }

        public boolean isPageComplete() {
            return this.selectedDriver != null;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedObject;
            this.selectedDriver = null;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof DBPDriver) {
                this.selectedDriver = (DriverDescriptor)selectedObject;
            }
            this.getWizard().getContainer().updateButtons();
        }
    }
}

