/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.model.runtime.OSDescriptorMatch;
import org.jkiss.utils.CommonUtils;

public class ProductBundleDescriptor
extends AbstractDescriptor {
    private final String id;
    private final String label;
    private final String description;
    private final List<OSDescriptorMatch> osMatches = new ArrayList<OSDescriptorMatch>();

    public ProductBundleDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        for (IConfigurationElement os : config.getChildren("os")) {
            this.osMatches.add(new OSDescriptorMatch(os.getAttribute("name"), os.getAttribute("arch"), CommonUtils.toBoolean((Object)os.getAttribute("exclude"))));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean matchesOS(OSDescriptor os) {
        for (OSDescriptorMatch match : this.osMatches) {
            if (match.matches(os)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.id + " (" + this.label + ")";
    }
}

