/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.config;

import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreEventTrigger;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTriggerBase;
import org.jkiss.dbeaver.ext.postgresql.ui.config.PostgreTriggerEditPage;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreEventTriggerConfigurator
implements DBEObjectConfigurator<PostgreEventTrigger> {
    public PostgreEventTrigger configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object parent, final @NotNull PostgreEventTrigger trigger, @NotNull Map<String, Object> options) {
        return (PostgreEventTrigger)new UITask<PostgreEventTrigger>(this){

            protected PostgreEventTrigger runTask() {
                TriggerEventEditPage editPage = new TriggerEventEditPage((PostgreTriggerBase)trigger);
                if (!editPage.edit()) {
                    return null;
                }
                trigger.setName(editPage.getEntityName());
                trigger.setEventType(editPage.eventType);
                trigger.setFunction(editPage.selectedFunction);
                return trigger;
            }
        }.execute();
    }

    static class TriggerEventEditPage
    extends PostgreTriggerEditPage {
        private Combo eventCombo;
        PostgreEventTrigger.TriggerEventTypes eventType;

        TriggerEventEditPage(PostgreTriggerBase trigger) {
            super(trigger);
        }

        @Override
        public void addExtraCombo(Composite parent) {
            this.eventCombo = UIUtils.createLabelCombo((Composite)parent, (String)PostgreMessages.dialog_trigger_label_combo_event_type, (String)PostgreMessages.dialog_trigger_label_combo_event_type_tip, (int)12);
            for (PostgreEventTrigger.TriggerEventTypes type : PostgreEventTrigger.TriggerEventTypes.values()) {
                this.eventCombo.add(type.name());
            }
            PostgreEventTrigger.TriggerEventTypes defaultEvent = PostgreEventTrigger.TriggerEventTypes.values()[0];
            this.eventCombo.setText(defaultEvent.name());
            this.eventType = defaultEvent;
            this.eventCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    eventType = (PostgreEventTrigger.TriggerEventTypes)CommonUtils.valueOf(PostgreEventTrigger.TriggerEventTypes.class, (String)eventCombo.getText());
                }
            });
        }

        public String getTitle() {
            return PostgreMessages.dialog_trigger_label_title;
        }
    }
}

