/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.suggestion;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Event;
import org.jkiss.utils.CommonUtils;

public class TextRenderingUtils {
    private TextRenderingUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawFirstLine(String text, GC gc, StyledText textWidget, int widgetOffset, Color textBackground) {
        Point origin;
        int line;
        if (gc == null) {
            return;
        }
        widgetOffset = Math.max(0, Math.min(widgetOffset, textWidget.getCharCount()));
        try {
            line = textWidget.getLineAtOffset(widgetOffset);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        int bias = TextRenderingUtils.calculateBaselineOffset(gc, textWidget, line);
        try {
            origin = textWidget.getLocationAtOffset(widgetOffset);
        }
        catch (IllegalArgumentException e) {
            origin = textWidget.getLocationAtOffset(textWidget.getCharCount() - 1);
            origin.y += textWidget.getLineHeight();
            origin.x = textWidget.getLeftMargin();
        }
        FontMetrics fm = gc.getFontMetrics();
        int fontHeight = fm.getHeight();
        int lineHeight = textWidget.getLineHeight();
        int verticalPosition = origin.y + (lineHeight - fontHeight) + bias;
        if (text != null && !gc.isDisposed()) {
            String remaining = TextRenderingUtils.getLineRemainder(widgetOffset, textWidget);
            if (!remaining.isEmpty() && text.endsWith(remaining)) {
                text = text.substring(0, text.length() - remaining.length());
            }
            Point textSize = gc.stringExtent(text);
            Color bgColor = gc.getBackground();
            gc.setBackground(textBackground);
            gc.fillRectangle(origin.x, verticalPosition, textSize.x, textSize.y);
            gc.drawString(text, origin.x, verticalPosition, true);
            gc.setBackground(bgColor);
            Transform t = null;
            Transform t2 = null;
            try {
                Event ev = new Event();
                ev.x = origin.x + textSize.x;
                ev.y = verticalPosition;
                ev.height = textSize.y;
                ev.width = textSize.x;
                ev.widget = textWidget;
                ev.gc = gc;
                t = new Transform(gc.getDevice());
                gc.getTransform(t);
                t2 = new Transform(gc.getDevice());
                gc.getTransform(t2);
                t2.translate((float)textSize.x, 0.0f);
                gc.setTransform(t2);
                Rectangle clip = gc.getClipping();
                Rectangle clip2 = gc.getClipping();
                clip2.x = origin.x;
                gc.setClipping(clip2);
                textWidget.notifyListeners(9, ev);
                gc.setClipping(clip);
                gc.setTransform(t);
            }
            finally {
                if (t != null && !t.isDisposed()) {
                    t.dispose();
                }
                if (t2 != null && !t2.isDisposed()) {
                    t2.dispose();
                }
            }
        }
    }

    public static void drawNextLines(String text, GC gc, StyledText textWidget, int offset) {
        int lineHeight = textWidget.getLineHeight();
        int fontHeight = gc.getFontMetrics().getHeight();
        Point origin = textWidget.getLocationAtOffset(offset);
        int x = textWidget.getLeftMargin();
        int y = origin.y + lineHeight + (lineHeight - fontHeight);
        gc.drawText(text, x, y, true);
    }

    public static int calculateBaselineOffset(GC gc, StyledText textWidget, int widgetLine) {
        if (gc == null) {
            return 0;
        }
        int offset = textWidget.getOffsetAtLine(widgetLine);
        int widgetBaseline = textWidget.getBaseline(offset);
        FontMetrics fm = gc.getFontMetrics();
        int fontBaseline = fm.getAscent() + fm.getLeading();
        return Math.max(0, widgetBaseline - fontBaseline);
    }

    private static String getLineRemainder(int offset, StyledText widget) {
        int line = widget.getLineAtOffset(offset);
        int start = widget.getOffsetAtLine(line);
        String contents = widget.getLine(line);
        return contents.substring(offset - start);
    }

    public static int widgetOffset2ModelOffset(ITextViewer viewer, int widgetOffset) {
        int n;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 ext5 = (ITextViewerExtension5)viewer;
            n = ext5.widgetOffset2ModelOffset(widgetOffset);
        } else {
            n = widgetOffset;
        }
        return n;
    }

    public static String removeOverlap(String originalText, String suggestion) {
        if (CommonUtils.isEmpty((String)suggestion) || CommonUtils.isEmpty((String)originalText)) {
            return suggestion;
        }
        String endOfOriginal = originalText.length() <= 20 ? originalText : originalText.substring(originalText.length() - 20);
        endOfOriginal = endOfOriginal.replaceAll("\\s+", " ").toLowerCase();
        String cleanSuggestion = suggestion.replaceAll("\\s+", " ");
        for (int length = Math.min(endOfOriginal.length(), cleanSuggestion.length()); length > 0; --length) {
            if (endOfOriginal.length() < length) continue;
            String endSubstring = endOfOriginal.substring(endOfOriginal.length() - length);
            if (!cleanSuggestion.toLowerCase().startsWith(endSubstring)) continue;
            return cleanSuggestion.substring(length).trim();
        }
        return suggestion;
    }
}

