/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableIndex;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableIndexColumn;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableCache;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class ExasolTableIndexCache
extends JDBCCompositeCache<ExasolSchema, ExasolTable, ExasolTableIndex, ExasolTableIndexColumn> {
    private static final String QUERYINDEX = "/*snapshot execution*/ SELECT * FROM SYS.%s_INDICES WHERE INDEX_SCHEMA = '%s'";
    private static final Pattern indexCols = Pattern.compile(".+\\((.+)\\)");

    public ExasolTableIndexCache(ExasolTableCache parentCache) {
        super((JDBCStructCache)parentCache, ExasolTable.class, (Object)"INDEX_TABLE", (Object)"REMARKS");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull ExasolSchema schema, @Nullable ExasolTable table) throws SQLException {
        String tablePrefix = schema.getDataSource().getTablePrefix(ExasolSysTablePrefix.ALL);
        StringBuilder sql = new StringBuilder(String.format(QUERYINDEX, tablePrefix, ExasolUtils.quoteString(schema.getName())));
        if (table != null) {
            sql.append(String.format(" AND INDEX_TABLE = '%s'", ExasolUtils.quoteString(table.getName())));
        }
        JDBCStatement dbstat = session.createStatement();
        dbstat.setQueryString(sql.toString());
        return dbstat;
    }

    protected ExasolTableIndex fetchObject(@NotNull JDBCSession session, @NotNull ExasolSchema schema, @NotNull ExasolTable table, @NotNull String indexName, @NotNull JDBCResultSet dbResult) {
        return new ExasolTableIndex(session.getProgressMonitor(), table, indexName, (ResultSet)dbResult);
    }

    protected ExasolTableIndexColumn[] fetchObjectRow(@NotNull JDBCSession session, @NotNull ExasolTable parent, @NotNull ExasolTableIndex forObject, @NotNull JDBCResultSet resultSet) throws DBException {
        Matcher m = indexCols.matcher(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMARKS"));
        ArrayList<ExasolTableIndexColumn> indexCols = new ArrayList<ExasolTableIndexColumn>();
        if (m.find()) {
            String[] colString = m.group(1).split(",");
            for (int i = 0; i < colString.length; ++i) {
                ExasolTableColumn tableColumn = colString[i] == null ? null : parent.getAttribute(session.getProgressMonitor(), colString[i]);
                indexCols.add(new ExasolTableIndexColumn(forObject, tableColumn, i + 1));
            }
        }
        ExasolTableIndexColumn[] arrayIndexCols = new ExasolTableIndexColumn[indexCols.size()];
        arrayIndexCols = indexCols.toArray(arrayIndexCols);
        return arrayIndexCols;
    }

    protected void cacheChildren(@NotNull DBRProgressMonitor monitor, @NotNull ExasolTableIndex index, @NotNull List<ExasolTableIndexColumn> cols) {
        index.setColumns(cols);
    }
}

