/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.jexl3.JexlExpression;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.dashboard.DBDashboardMapQuery;
import org.jkiss.dbeaver.model.dashboard.DBDashboardQuery;
import org.jkiss.dbeaver.model.dashboard.DashboardIcons;
import org.jkiss.dbeaver.model.dashboard.data.DashboardDataset;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListControl;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewCompositeControl;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemRenderer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardRendererType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardUIRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DashboardViewItem
extends Composite
implements DashboardItemContainer {
    public static final int DEFAULT_HEIGHT = 200;
    private final DashboardListControl groupContainer;
    private final DashboardItemViewSettings viewItemConfig;
    private Date lastUpdateTime;
    private DashboardRendererType curViewType;
    private DashboardItemRenderer renderer;
    private Composite dashboardControl;
    private final Label titleLabel;
    private final ToolBarManager titleToolbarManager;
    private final Composite chartComposite;
    private boolean autoUpdateEnabled;

    public DashboardViewItem(@NotNull DashboardListControl parent, @NotNull DashboardItemConfiguration item) {
        super((Composite)parent, 0x20000000);
        this.setLayoutData(new GridData(1808));
        this.groupContainer = parent;
        this.viewItemConfig = this.groupContainer.getView().getViewConfiguration().getItemConfig(item.getId());
        if (this.viewItemConfig == null) {
            throw new IllegalStateException("View item configuration not found for '" + item.getId() + "'");
        }
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.setLayout((Layout)layout);
        Color defFG = UIStyles.getDefaultTextForeground();
        Color defBG = UIStyles.getDefaultTextBackground();
        this.setBackground(defBG);
        Composite titleComposite = new Composite((Composite)this, 0);
        titleComposite.setLayoutData((Object)new GridData(768));
        titleComposite.setBackground(defBG);
        titleComposite.setForeground(defFG);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 3;
        gridLayout.marginWidth = 3;
        titleComposite.setLayout((Layout)gridLayout);
        DBIcon icon = DashboardIcons.DASHBOARD;
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        icon = item.getDashboardProvider().isDatabaseRequired() && dataSourceContainer != null ? dataSourceContainer.getDriver().getIcon() : item.getDashboardProvider().getIcon();
        Label titleIcon = new Label(titleComposite, 0);
        titleIcon.setImage(DBeaverIcons.getImage((DBPImage)icon));
        this.titleLabel = new Label(titleComposite, 0);
        this.titleLabel.setFont(parent.getTitleFont());
        this.updateChartLabel(item);
        this.titleLabel.setLayoutData((Object)new GridData(768));
        this.titleLabel.setBackground(defBG);
        this.titleToolbarManager = new ToolBarManager(0x800100);
        ToolBar toolBar = this.titleToolbarManager.createControl(titleComposite);
        toolBar.setBackground(defBG);
        this.createContextMenu((Control)this.titleLabel);
        this.chartComposite = new Composite((Composite)this, 0);
        this.chartComposite.setLayoutData((Object)new GridData(1808));
        this.chartComposite.setLayout((Layout)new FillLayout());
        this.createDashboardRenderer();
        this.groupContainer.addItem(this);
        this.addDisposeListener(e -> this.groupContainer.removeItem(this));
        this.addPaintListener(this::paintItem);
        this.autoUpdateEnabled = true;
    }

    private void updateChartLabel(@NotNull DashboardItemConfiguration item) {
        if (this.viewItemConfig == null) {
            this.titleLabel.setText(item.getId());
        } else {
            this.titleLabel.setText(this.evaluateChartLabel(item.getTitle()));
        }
        this.titleLabel.setToolTipText(CommonUtils.notEmpty((String)item.getDescription()));
    }

    private String evaluateChartLabel(String label) {
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (dataSourceContainer != null) {
            return GeneralUtils.replaceVariables((String)label, (IVariableResolver)dataSourceContainer.getVariablesResolver(true));
        }
        return label;
    }

    public DashboardListControl getGroupContainer() {
        return this.groupContainer;
    }

    private void createContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager(null, this.getItemDescriptor().getId() + "_context_menu");
        menuMgr.addMenuListener(manager -> this.fillDashboardContextMenu((IMenuManager)menuMgr, false));
        Menu menu = menuMgr.createContextMenu((Control)this);
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
    }

    private void createDashboardRenderer() {
        try {
            this.curViewType = this.viewItemConfig.getViewType();
            this.renderer = this.curViewType.createRenderer();
            this.dashboardControl = this.renderer.createDashboard(this.chartComposite, this, this.groupContainer.getView(), this.computeSize(-1, -1));
            this.updateToolBarActions();
        }
        catch (DBException e) {
            Text errorLabel = new Text((Composite)this, 74);
            errorLabel.setText(NLS.bind((String)UIDashboardMessages.dashboard_item_errorlabel_text, (Object)this.viewItemConfig.getItemId(), (Object)e.getMessage()));
            errorLabel.setLayoutData((Object)new GridData(2, 2, true, true));
        }
        this.initChartRenderer();
    }

    private void updateToolBarActions() {
        this.titleToolbarManager.removeAll();
        this.renderer.fillDashboardToolbar(this, (IContributionManager)this.titleToolbarManager, this.dashboardControl, this.viewItemConfig);
        this.titleToolbarManager.update(false);
    }

    private void initChartRenderer() {
        Control dbCanvas;
        Composite composite = this.dashboardControl;
        if (composite instanceof DashboardViewCompositeControl) {
            DashboardViewCompositeControl chart = (DashboardViewCompositeControl)composite;
            v0 = chart.getDashboardControl();
        } else {
            v0 = dbCanvas = null;
        }
        if (dbCanvas == null) {
            return;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DashboardViewItem.this.groupContainer.setSelection(DashboardViewItem.this);
            }
        };
        dbCanvas.addMouseListener((MouseListener)mouseAdapter);
        this.addMouseListener((MouseListener)mouseAdapter);
        this.titleLabel.addMouseListener((MouseListener)mouseAdapter);
        dbCanvas.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DashboardViewItem.this.groupContainer.setSelection(DashboardViewItem.this);
                DashboardViewItem.this.redraw();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        dbCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DashboardViewItem.this.groupContainer.handleKeyEvent(e);
            }
        });
        this.dashboardControl.addDisposeListener(e -> this.renderer.disposeDashboard(this));
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    private void paintItem(PaintEvent e) {
        if (UIUtils.isInDialog((Control)this)) {
            return;
        }
        Point itemSize = this.getSize();
        e.gc.setForeground(this.getDisplay().getSystemColor(17));
        if (this.groupContainer.getSelectedItem() == this) {
            e.gc.setLineWidth(2);
            e.gc.setLineStyle(1);
        } else {
            e.gc.setLineWidth(1);
            e.gc.setLineStyle(1);
        }
        e.gc.drawRectangle(1, 1, itemSize.x - 2, itemSize.y - 2);
    }

    public int getDefaultHeight() {
        return 200;
    }

    public int getDefaultWidth() {
        return (int)(this.viewItemConfig.getWidthRatio() * (float)this.getDefaultHeight());
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point listAreaSize = this.groupContainer.getSize();
        if (this.groupContainer.getView().isSingleChartMode() || listAreaSize.x <= 0 || listAreaSize.y <= 0) {
            return super.computeSize(wHint, hHint, changed);
        }
        GridLayout listLayout = (GridLayout)this.groupContainer.getLayout();
        int listRowCount = this.groupContainer.getListRowCount();
        int listColumnCount = this.groupContainer.getListColumnCount();
        int width = (listAreaSize.x - listLayout.marginWidth * 2 - listLayout.horizontalSpacing * (listColumnCount - 1)) / listColumnCount;
        int height = (listAreaSize.y - listLayout.marginHeight * 2 - listLayout.verticalSpacing * (listRowCount - 1)) / listRowCount;
        return new Point(width, height);
    }

    public DashboardItemViewSettings getViewItemConfig() {
        return this.viewItemConfig;
    }

    @Override
    public DashboardItemConfiguration getItemDescriptor() {
        return this.viewItemConfig.getItemConfiguration();
    }

    @Override
    public DashboardItemViewSettings getItemConfiguration() {
        return this.viewItemConfig;
    }

    @Override
    public int getDashboardMaxItems() {
        return this.viewItemConfig.getMaxItems();
    }

    @Override
    public long getDashboardMaxAge() {
        return this.viewItemConfig.getMaxAge();
    }

    @Override
    public DBPProject getProject() {
        return this.groupContainer.getProject();
    }

    @Override
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.groupContainer.getDataSourceContainer();
    }

    @Override
    public DashboardGroupContainer getGroup() {
        return this.groupContainer;
    }

    @Override
    public DBDashboardMapQuery getMapQuery() {
        DashboardItemConfiguration dashboard = this.viewItemConfig.getItemConfiguration();
        return dashboard == null ? null : dashboard.getMapQuery();
    }

    @Override
    public String[] getMapKeys() {
        DashboardItemConfiguration dashboard = this.viewItemConfig.getItemConfiguration();
        return dashboard == null ? null : dashboard.getMapKeys();
    }

    @Override
    public String[] getMapLabels() {
        DashboardItemConfiguration dashboard = this.viewItemConfig.getItemConfiguration();
        return dashboard == null ? null : dashboard.getMapLabels();
    }

    @Override
    public JexlExpression getMapFormula() {
        DashboardItemConfiguration dashboard = this.viewItemConfig.getItemConfiguration();
        return dashboard == null ? null : dashboard.getMapFormulaExpr();
    }

    @Override
    public List<? extends DBDashboardQuery> getQueryList() {
        DashboardItemConfiguration dashboard = this.viewItemConfig.getItemConfiguration();
        return dashboard == null ? null : dashboard.getQueries();
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void updateDashboardData(DashboardDataset dataset) {
        UIUtils.asyncExec(() -> {
            if (this.renderer != null) {
                this.renderer.updateDashboardData(this, this.lastUpdateTime, dataset);
                this.lastUpdateTime = new Date();
            }
        });
    }

    @Override
    public void resetDashboardData() {
        UIUtils.asyncExec(() -> {
            if (this.renderer != null) {
                this.renderer.resetDashboardData(this, this.lastUpdateTime);
            }
        });
    }

    @Override
    public void updateDashboardView() {
        UIUtils.asyncExec(() -> {
            boolean forceLayout = false;
            if (this.viewItemConfig.getViewType() != this.curViewType) {
                if (this.dashboardControl != null) {
                    this.dashboardControl.dispose();
                    forceLayout = true;
                }
                this.createDashboardRenderer();
            } else if (this.renderer != null) {
                this.renderer.updateDashboardView(this);
            }
            if (forceLayout) {
                this.layout(true, true);
            }
        });
    }

    @Override
    public boolean isAutoUpdateEnabled() {
        return this.autoUpdateEnabled;
    }

    @Override
    public void disableAutoUpdate() {
        this.autoUpdateEnabled = false;
    }

    @Override
    public long getUpdatePeriod() {
        return this.viewItemConfig.getUpdatePeriod();
    }

    public Composite getDashboardControl() {
        return this.dashboardControl;
    }

    public void moveViewFrom(DashboardViewItem item, boolean clearOriginal) {
        this.renderer.moveDashboardView(this, item, clearOriginal);
    }

    @Override
    public void fillDashboardContextMenu(@NotNull IMenuManager manager, boolean singleChartMode) {
        if (!singleChartMode) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.dashboard.view"));
            manager.add((IContributionItem)new Separator());
        }
        List<DashboardRendererType> viewTypes = DashboardUIRegistry.getInstance().getSupportedViewTypes(this.getItemDescriptor().getDataType());
        if (!UIUtils.isInDialog((Control)this.dashboardControl) && viewTypes.size() > 1) {
            MenuManager viewMenu = new MenuManager(UIDashboardMessages.dashboard_chart_composite_menu_manager_text);
            for (final DashboardRendererType viewType : viewTypes) {
                Action changeViewAction = new Action(this, viewType.getTitle(), 8){
                    final /* synthetic */ DashboardViewItem this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0, arg1);
                    }

                    public boolean isChecked() {
                        return this.this$0.getItemConfiguration().getViewType() == viewType;
                    }

                    public void runWithEvent(Event event) {
                        this.this$0.getViewItemConfig().setViewType(viewType);
                        this.this$0.getGroup().getView().saveChanges();
                        this.this$0.updateDashboardView();
                    }
                };
                if (viewType.getIcon() != null) {
                    changeViewAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)viewType.getIcon()));
                }
                viewMenu.add((IAction)changeViewAction);
            }
            manager.add((IContributionItem)viewMenu);
        }
        if (!singleChartMode) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.dashboard.add"));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("toggleCatalogPanel", "true");
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.dashboard.catalog.show", params));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.dashboard.remove"));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.chart.refresh"));
        }
        manager.add((IContributionItem)new Separator());
    }

    @Override
    public void refreshInfo() {
        this.updateChartLabel(this.getItemDescriptor());
    }

    public String toString() {
        DashboardItemConfiguration dashboard = this.viewItemConfig.getItemConfiguration();
        return dashboard == null ? this.viewItemConfig.getItemId() : dashboard.getName();
    }
}

