/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.StringUtils;

public class BaseErrorDialog
extends BaseDialog {
    private static final String NESTING_INDENT = "  ";
    public static final int DEFAULT_MESSAGE_WIDTH = 80;
    private static final int DETAILS_MESSAGE_WIDTH = 130;
    protected String message;
    private Button detailsButton;
    private final String title;
    private Text detailsText;
    private final int displayMask;
    private IStatus status;
    private boolean shouldIncludeTopLevelErrorInDetails = false;
    private Composite detailPanel;

    public BaseErrorDialog(@NotNull Shell parentShell, @Nullable String dialogTitle, @Nullable String message, @NotNull IStatus status, int displayMask) {
        super(parentShell, dialogTitle, (DBPImage)DBIcon.STATUS_ERROR);
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
        this.message = message == null ? status.getMessage() : message;
        this.status = status;
        this.displayMask = displayMask;
    }

    @Nullable
    protected Text getDetailsText() {
        return this.detailsText;
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(@NotNull Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    @Override
    protected void createButtonsForLeftButtonBar(@NotNull Composite parent) {
        this.createDetailsButton(parent);
    }

    @Override
    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void createDetailsButton(@NotNull Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Composite createContents(@NotNull Composite parent) {
        Composite contents = (Composite)super.createContents(parent);
        this.createDropDownList(contents);
        return contents;
    }

    @Override
    @NotNull
    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        GridData gd = new GridData(768);
        dialogArea.setLayoutData((Object)gd);
        DBPImage image = this.getImage();
        ++((GridLayout)dialogArea.getLayout()).numColumns;
        Label imageLabel = new Label(dialogArea, 0);
        imageLabel.setImage(DBeaverIcons.getImage(image));
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
        ++((GridLayout)dialogArea.getLayout()).numColumns;
        Text messageText = new Text(dialogArea, 74);
        messageText.setText(this.message);
        this.applyMessageSizes(messageText, false, 80);
        return dialogArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMessageSizes(@NotNull Text messageText, boolean fillVertical, int messageWidthHintChars) {
        Point textSize;
        GridData gd = new GridData(fillVertical ? 1808 : 768);
        gd.minimumWidth = 300;
        int fontHeight = UIUtils.getFontHeight((Control)messageText);
        int maxDialogWidth = fontHeight * messageWidthHintChars;
        GC gc = new GC((Drawable)messageText);
        try {
            gc.setFont(messageText.getFont());
            double charsPerLine = (double)maxDialogWidth / gc.getFontMetrics().getAverageCharacterWidth();
            String wrappedMessage = StringUtils.wrap((String)messageText.getText(), (int)((int)charsPerLine));
            textSize = gc.textExtent(wrappedMessage);
            textSize.y += 5;
            textSize.x += fontHeight * 2;
            if (RuntimeUtils.isMacOS()) {
                textSize.x += fontHeight * 8;
            }
        }
        finally {
            gc.dispose();
        }
        gd.heightHint = Math.min(textSize.y, fontHeight * 10);
        gd.widthHint = Math.min(textSize.x, maxDialogWidth);
        gd.grabExcessHorizontalSpace = true;
        messageText.setLayoutData((Object)gd);
    }

    @Override
    @NotNull
    public DBPImage getImage() {
        if (this.status != null) {
            if (this.status.getSeverity() == 2) {
                return DBIcon.STATUS_WARNING;
            }
            if (this.status.getSeverity() == 1) {
                return DBIcon.STATUS_INFO;
            }
        }
        return DBIcon.STATUS_ERROR;
    }

    protected boolean isDetailsVisible() {
        return this.detailPanel.isVisible();
    }

    protected void createDropDownList(@NotNull Composite parent) {
        this.detailPanel = super.createDialogPanelWithMargins(parent, true);
        this.detailsText = new Text(this.detailPanel, 2634);
        GridData data = new GridData(1808);
        data.widthHint = 100;
        this.detailPanel.setVisible(false);
        ((GridData)this.detailPanel.getLayoutData()).exclude = true;
        this.detailsText.setLayoutData((Object)data);
        this.populateList();
        this.applyMessageSizes(this.detailsText, true, 130);
    }

    public int open() {
        if (BaseErrorDialog.shouldDisplay(this.status, this.displayMask)) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    private void populateList() {
        this.populateList(this.status, 0, this.shouldIncludeTopLevelErrorInDetails);
        int rowCount = 10;
        ((GridData)this.detailsText.getLayoutData()).heightHint = rowCount * UIUtils.getFontHeight((Control)this.detailsText);
    }

    private boolean listContentExists() {
        return this.listContentExists(this.status, this.shouldIncludeTopLevelErrorInDetails);
    }

    private void populateList(@NotNull IStatus status, int nesting, boolean includeStatus) {
        IStatus[] children;
        String message;
        if (!status.matches(this.displayMask)) {
            return;
        }
        Throwable t = status.getException();
        boolean incrementNesting = false;
        String statusMessage = null;
        if (includeStatus) {
            StringBuilder sb = new StringBuilder();
            sb.append(NESTING_INDENT.repeat(Math.max(0, nesting)));
            statusMessage = status.getMessage();
            sb.append(statusMessage.trim());
            sb.append("\n");
            this.detailsText.append(sb.toString());
            incrementNesting = true;
        }
        if (!(t instanceof CoreException) && t != null && (message = GeneralUtils.makeStandardErrorMessage((Throwable)t)) != null && !Objects.equals(statusMessage, message)) {
            String sb = NESTING_INDENT.repeat(Math.max(0, nesting)) + message.trim() + "\n";
            this.detailsText.append(sb);
            incrementNesting = true;
        }
        if (incrementNesting) {
            ++nesting;
        }
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            IStatus eStatus = ce.getStatus();
            if (this.message == null || !this.message.contains(eStatus.getMessage())) {
                this.populateList(eStatus, nesting, false);
            }
        }
        for (IStatus element : children = status.getChildren()) {
            this.populateList(element, nesting, false);
        }
    }

    private boolean listContentExists(IStatus buildingStatus, boolean includeStatus) {
        IStatus[] children;
        if (!buildingStatus.matches(this.displayMask)) {
            return false;
        }
        Throwable t = buildingStatus.getException();
        if (includeStatus) {
            return true;
        }
        if (t != null && !(t instanceof CoreException)) {
            return true;
        }
        boolean result = false;
        if (t != null) {
            CoreException ce = (CoreException)t;
            IStatus eStatus = ce.getStatus();
            if (this.message == null || !this.message.contains(eStatus.getMessage())) {
                result |= this.listContentExists(eStatus, true);
            }
        }
        for (IStatus element : children = buildingStatus.getChildren()) {
            result |= this.listContentExists(element, true);
        }
        return result;
    }

    protected static boolean shouldDisplay(@NotNull IStatus status, int mask) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status.matches(mask);
        }
        for (IStatus element : children) {
            if (!element.matches(mask)) continue;
            return true;
        }
        return false;
    }

    private void toggleDetailsArea() {
        boolean opened = false;
        if (this.isDetailsVisible()) {
            this.detailPanel.setVisible(false);
            ((GridData)this.detailPanel.getLayoutData()).exclude = true;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else if (this.getDialogArea() != null) {
            this.detailPanel.setVisible(true);
            ((GridData)this.detailPanel.getLayoutData()).exclude = false;
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            opened = true;
        }
        this.getShell().layout(true, true);
        Point newSize = this.getShell().computeSize(-1, -1);
        if (opened) {
            UIUtils.resizeShell(this.getShell());
        } else {
            this.getShell().setSize(new Point(newSize.x, newSize.y));
        }
    }

    protected final void showDetailsArea() {
        if (!this.isDetailsVisible()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return this.listContentExists();
    }

    protected final void setStatus(IStatus status) {
        if (this.status != status) {
            this.status = status;
        }
        this.shouldIncludeTopLevelErrorInDetails = true;
        this.repopulateList();
    }

    private void repopulateList() {
        if (this.detailsText != null && !this.detailsText.isDisposed()) {
            this.detailsText.setText("");
            this.populateList();
        }
    }
}

