/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.autorefresh;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.autorefresh.RefreshSettings;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class AutoRefreshConfigDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.AutoRefreshConfigDialog";
    private RefreshSettings refreshSettings;

    AutoRefreshConfigDialog(Shell parentShell, RefreshSettings settings) {
        super(parentShell, "Auto-refresh configuration", (DBPImage)UIIcon.CLOCK_START);
        this.refreshSettings = new RefreshSettings(settings);
    }

    public RefreshSettings getRefreshSettings() {
        return this.refreshSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    @Override
    @NotNull
    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite settingsGroup = UIUtils.createTitledComposite(composite, "Settings", 2, 1808);
        final Spinner intervalSpinner = UIUtils.createLabelSpinner(settingsGroup, "Interval (sec)", "Auto-refresh interval in seconds", this.refreshSettings.getRefreshInterval(), 1, Integer.MAX_VALUE);
        intervalSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ AutoRefreshConfigDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                this.this$0.refreshSettings.setRefreshInterval(intervalSpinner.getSelection());
            }
        });
        final Button stopOnErrorCheck = UIUtils.createCheckbox(settingsGroup, "Stop on error", "Stop auto-refresh if error happens", this.refreshSettings.isStopOnError(), 2);
        stopOnErrorCheck.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ AutoRefreshConfigDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                this.this$0.refreshSettings.setStopOnError(stopOnErrorCheck.getSelection());
            }
        });
        return composite;
    }
}

