/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.stream.IAppendableDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterTXT
extends StreamExporterAbstract
implements IAppendableDataExporter {
    private static final String PROP_BATCH_SIZE = "batchSize";
    private static final String PROP_MIN_COLUMN_LENGTH = "minColumnLength";
    private static final String PROP_MAX_COLUMN_LENGTH = "maxColumnLength";
    private static final String PROP_SHOW_NULLS = "showNulls";
    private static final String PROP_DELIM_LEADING = "delimLeading";
    private static final String PROP_DELIM_HEADER = "delimHeader";
    private static final String PROP_DELIM_TRAILING = "delimTrailing";
    private static final String PROP_DELIM_BETWEEN = "delimBetween";
    private static final String PROP_SHOW_HEADER = "showHeader";
    private int batchSize = 200;
    private int maxColumnSize = 0;
    private int minColumnSize = 1;
    private boolean showHeader;
    private boolean showNulls;
    private boolean delimLeading;
    private boolean delimHeader;
    private boolean delimTrailing;
    private String delimBetween;
    private Deque<CellValue[]> batchQueue;
    private static final boolean QUOTE_BLOBS = true;
    private static final char QUOTE_BLOB_CHAR = '\"';
    private static final String QUOTE_BLOB_REPLACEMENT = "\\\"";
    private static final String BLOB_OVERFLOW_MARK = " [BLOB is too large]";
    private static final int BLOB_CONTENT_MIN_LENGTH = 20;
    private static final String RAW_BLOB_OPEN = "[BLOB[";
    private static final String RAW_BLOB_CLOSE = "]]";
    private final StringBuilder blobContentBuffer = new StringBuilder();
    private DBDAttributeBinding[] columns;
    private int[] colWidths;
    private int blobContentMaxLength = 0;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        Map<String, Object> properties = site.getProperties();
        this.batchSize = Math.max(CommonUtils.toInt((Object)properties.get(PROP_BATCH_SIZE), (int)200), 200);
        this.minColumnSize = Math.max(CommonUtils.toInt((Object)properties.get(PROP_MIN_COLUMN_LENGTH), (int)1), 1);
        this.maxColumnSize = Math.max(CommonUtils.toInt((Object)properties.get(PROP_MAX_COLUMN_LENGTH), (int)0), 0);
        this.showNulls = CommonUtils.getBoolean((Object)properties.get(PROP_SHOW_NULLS), (boolean)false);
        this.delimLeading = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_LEADING), (boolean)true);
        this.delimHeader = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_HEADER), (boolean)true);
        this.delimTrailing = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_TRAILING), (boolean)true);
        String prop = CommonUtils.toString((Object)properties.get(PROP_DELIM_BETWEEN));
        this.delimBetween = Boolean.FALSE.toString().equals(prop) ? " " : prop;
        this.showHeader = CommonUtils.getBoolean((Object)properties.get(PROP_SHOW_HEADER), (boolean)true);
        this.batchQueue = new ArrayDeque<CellValue[]>(this.batchSize);
        if (this.maxColumnSize > 0) {
            this.maxColumnSize = Math.max(this.maxColumnSize, this.minColumnSize);
        }
        if (this.maxColumnSize == 0) {
            this.blobContentMaxLength = Integer.MAX_VALUE - BLOB_OVERFLOW_MARK.length();
        } else {
            this.blobContentMaxLength = Math.min(this.maxColumnSize, Integer.MAX_VALUE) - BLOB_OVERFLOW_MARK.length();
            if (this.blobContentMaxLength < 0) {
                this.blobContentMaxLength = 20;
            }
        }
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.colWidths = new int[this.columns.length];
        Arrays.fill(this.colWidths, this.minColumnSize);
        if (this.showHeader) {
            CellValue[] header = new CellValue[this.columns.length];
            for (int index = 0; index < this.columns.length; ++index) {
                String cell = DataExporterTXT.getAttributeName(this.columns[index]);
                if (this.maxColumnSize > 0) {
                    cell = CommonUtils.truncateString((String)cell, (int)this.maxColumnSize);
                }
                header[index] = new CellTextValue(cell);
            }
            this.appendRow(header, session.getProgressMonitor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        CellValue[] values = new CellValue[this.columns.length];
        for (int index = 0; index < this.columns.length; ++index) {
            if (row[index] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[index];
                if (ContentUtils.isTextContent((DBDContent)content)) {
                    try {
                        DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                        if (cs == null) {
                            values[index] = new CellTextValue("[NULL]");
                            continue;
                        }
                        values[index] = new CellTextValue(this.stringifyContent(cs.getContentReader()));
                        continue;
                    }
                    finally {
                        content.release();
                    }
                }
                values[index] = new CellContentValue(this, content);
                continue;
            }
            String cell = this.getCellString(this.columns[index], row[index]);
            if (this.maxColumnSize > 0) {
                cell = CommonUtils.truncateString((String)cell, (int)this.maxColumnSize);
            }
            values[index] = new CellTextValue(cell);
        }
        this.appendRow(values, session.getProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringifyContent(Reader reader) throws IOException {
        try {
            int count;
            this.blobContentBuffer.setLength(0);
            int rest = this.blobContentMaxLength;
            this.blobContentBuffer.append('\"');
            rest -= 2;
            char[] buffer = new char[2000];
            while ((count = reader.read(buffer, 0, buffer.length)) > 0) {
                if (QUOTE_BLOB_REPLACEMENT != null) {
                    if (QUOTE_BLOB_REPLACEMENT.length() > 1) {
                        for (int i = 0; i < count; ++i) {
                            if (buffer[i] == '\"') {
                                if (this.blobContentBuffer.length() + QUOTE_BLOB_REPLACEMENT.length() <= this.blobContentMaxLength) {
                                    this.blobContentBuffer.append(QUOTE_BLOB_REPLACEMENT);
                                    rest -= QUOTE_BLOB_REPLACEMENT.length() - 1;
                                    continue;
                                }
                                break;
                            }
                            this.blobContentBuffer.append(buffer[i]);
                        }
                    } else {
                        int limit = Math.min(count, rest);
                        for (int i = 0; i < limit; ++i) {
                            if (buffer[i] == '\"') {
                                this.blobContentBuffer.append(QUOTE_BLOB_REPLACEMENT);
                                continue;
                            }
                            this.blobContentBuffer.append(buffer[i]);
                        }
                    }
                } else {
                    this.blobContentBuffer.append(buffer, 0, Math.min(count, rest));
                }
                if (rest < count) {
                    this.blobContentBuffer.append(BLOB_OVERFLOW_MARK);
                    break;
                }
                rest -= count;
            }
            this.blobContentBuffer.append('\"');
            String string = this.blobContentBuffer.toString();
            return string;
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
        this.writeQueue(monitor);
    }

    @Override
    public void importData(@NotNull IStreamDataExporterSite site) {
    }

    @Override
    public boolean shouldTruncateOutputFileBeforeExport() {
        return false;
    }

    private void appendRow(CellValue[] row, DBRProgressMonitor monitor) throws DBCException, IOException {
        if (this.batchQueue.size() == this.batchSize) {
            this.writeQueue(monitor);
        }
        this.batchQueue.add(row);
    }

    private void writeQueue(DBRProgressMonitor monitor) throws DBCException, IOException {
        if (this.batchQueue.isEmpty()) {
            return;
        }
        ExportTextTarget target = new ExportTextTarget(this.getWriter(), monitor);
        for (CellValue[] row : this.batchQueue) {
            for (int index = 0; index < this.columns.length; ++index) {
                CellValue value = row[index];
                int valueLength = value.getTextLength();
                if (this.maxColumnSize > 0 && valueLength > this.maxColumnSize) {
                    this.colWidths[index] = this.maxColumnSize;
                    continue;
                }
                if (valueLength <= this.colWidths[index]) continue;
                this.colWidths[index] = valueLength;
            }
        }
        while (!this.batchQueue.isEmpty()) {
            if (this.showHeader) {
                this.writeRow(target, this.batchQueue.poll(), ' ');
            }
            if (this.delimHeader) {
                this.delimHeader = false;
                this.writeRow(target, null, '-');
            }
            if (this.showHeader) continue;
            this.writeRow(target, this.batchQueue.poll(), ' ');
        }
        this.getWriter().flush();
    }

    private void writeRow(ExportTextTarget target, CellValue[] values, char fill) throws DBCException, IOException {
        if (this.delimLeading) {
            target.append('|');
        }
        int length = this.columns.length;
        for (int index = 0; index < length; ++index) {
            int actualLength;
            int n = actualLength = ArrayUtils.isEmpty((Object[])values) ? 0 : values[index].exportTo(target);
            if (actualLength > this.colWidths[index]) {
                this.colWidths[index] = Math.min(actualLength, this.maxColumnSize);
            }
            if (index < length - 1 || this.delimTrailing || fill != ' ') {
                for (int width = actualLength; width < this.colWidths[index]; ++width) {
                    target.append(fill);
                }
            }
            if (index >= length - 1) continue;
            target.append(this.delimBetween);
        }
        if (this.delimTrailing) {
            target.append('|');
        }
        target.append(CommonUtils.getLineSeparator());
        target.flush();
    }

    private String getCellString(DBDAttributeBinding attr, Object value) {
        String displayString = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, value, this.getValueExportFormat(attr));
        if (DBUtils.isNullValue((Object)value)) {
            return this.showNulls ? "[NULL]" : "";
        }
        return CommonUtils.getSingleLineString((String)displayString);
    }

    private static String getAttributeName(DBDAttributeBinding attr) {
        if (CommonUtils.isEmpty((String)attr.getLabel())) {
            return attr.getName();
        }
        return attr.getLabel();
    }

    private static interface CellValue {
        public int getTextLength();

        public int exportTo(ExportTextTarget var1) throws DBCException, IOException;
    }

    private static class CellTextValue
    implements CellValue {
        public final String text;

        public CellTextValue(String text) {
            this.text = text;
        }

        @Override
        public int getTextLength() {
            return this.text.length();
        }

        @Override
        public int exportTo(ExportTextTarget target) {
            return target.append(this.text);
        }
    }

    private class CellContentValue
    implements CellValue {
        public final DBDContent content;

        public CellContentValue(DataExporterTXT dataExporterTXT, DBDContent content) {
            this.content = content;
        }

        @Override
        public int getTextLength() {
            try {
                long length = this.content.getContentLength() + (long)DataExporterTXT.RAW_BLOB_OPEN.length() + (long)DataExporterTXT.RAW_BLOB_CLOSE.length();
                return (int)Math.min(Integer.MAX_VALUE, length);
            }
            catch (DBCException ex) {
                return 0;
            }
        }

        @Override
        public int exportTo(ExportTextTarget target) throws DBCException, IOException {
            try {
                int n = target.append(this.content);
                return n;
            }
            finally {
                this.content.release();
            }
        }
    }

    private class ExportTextTarget {
        private final PrintWriter writer;
        private final DBRProgressMonitor monitor;
        private final StringBuilder stringBuilder = new StringBuilder();

        public ExportTextTarget(PrintWriter writer, DBRProgressMonitor monitor) {
            this.writer = writer;
            this.monitor = monitor;
        }

        public void flush() {
            this.writer.write(this.stringBuilder.toString());
            this.stringBuilder.setLength(0);
        }

        public int append(char ch) {
            this.stringBuilder.append(ch);
            return 1;
        }

        public int append(String text) {
            this.stringBuilder.append(text);
            return text.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int append(DBDContent content) throws IOException, DBCException {
            DBDContentStorage cs = content.getContents(this.monitor);
            if (cs == null) {
                return this.append("[NULL]");
            }
            try {
                this.append(DataExporterTXT.RAW_BLOB_OPEN);
                this.flush();
                this.writer.flush();
                DataExporterTXT.this.getSite().writeBinaryData(cs);
                this.append(DataExporterTXT.RAW_BLOB_CLOSE);
                int n = (int)Math.min(Integer.MAX_VALUE, (long)DataExporterTXT.RAW_BLOB_OPEN.length() + cs.getContentLength() + (long)DataExporterTXT.RAW_BLOB_CLOSE.length());
                return n;
            }
            finally {
                cs.release();
            }
        }
    }
}

