/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.SQLDialectInsertReplaceMethod;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.struct.DBSDataBulkLoader;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferEventProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.ui.IDataTransferEventProcessorConfigurator;
import org.jkiss.dbeaver.tools.transfer.ui.controls.EventProcessorComposite;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.DataTransferPageNodeSettings;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseConsumerPageLoadSettings
extends DataTransferPageNodeSettings {
    private static final Log log = Log.getLog(DatabaseConsumerPageLoadSettings.class);
    private final String HELP_TOPIC_REPLACE_METHOD = "Data-Import-and-Replace";
    private Button transferAutoGeneratedColumns;
    private Button truncateTargetTable;
    private Button disableReferentialIntegrity;
    private Combo onDuplicateKeyInsertMethods;
    private String disableReferentialIntegrityCheckboxTooltip;
    private boolean isDisablingReferentialIntegritySupported;
    private Text multiRowInsertBatch;
    private Button skipBindValues;
    private Button useBatchCheck;
    private Button ignoreDuplicateRows;
    private Button useBulkLoadCheck;
    private Button logInsertQueriesCheck;
    private List<SQLDialectInsertReplaceMethod> availableInsertMethodsDescriptors;
    private final Map<String, EventProcessorComposite<?>> processors = new HashMap();

    public DatabaseConsumerPageLoadSettings() {
        super(DTUIMessages.database_consumer_wizard_name);
        this.setTitle(DTUIMessages.database_consumer_wizard_title);
        this.setDescription(DTUIMessages.database_consumer_wizard_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        final DatabaseConsumerSettings settings = this.getSettings();
        Composite loadSettings = UIUtils.createTitledComposite((Composite)composite, (String)DTUIMessages.database_consumer_wizard_name, (int)2, (int)34);
        this.transferAutoGeneratedColumns = UIUtils.createCheckbox((Composite)loadSettings, (String)DTUIMessages.database_consumer_wizard_transfer_checkbox_label, (String)DTUIMessages.database_consumer_wizard_transfer_checkbox_tooltip, (boolean)settings.isTransferAutoGeneratedColumns(), (int)2);
        this.transferAutoGeneratedColumns.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                settings.setTransferAutoGeneratedColumns(this.this$0.transferAutoGeneratedColumns.getSelection());
            }
        });
        this.truncateTargetTable = UIUtils.createCheckbox((Composite)loadSettings, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_label, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_description, (boolean)settings.isTruncateBeforeLoad(), (int)2);
        this.truncateTargetTable.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.this$0.truncateTargetTable.getSelection() && !this.this$0.confirmDataTruncate()) {
                    this.this$0.truncateTargetTable.setSelection(false);
                    return;
                }
                settings.setTruncateBeforeLoad(this.this$0.truncateTargetTable.getSelection());
            }
        });
        this.loadUISettingsForDisableReferentialIntegrityCheckbox();
        settings.setDisableReferentialIntegrity(this.isDisablingReferentialIntegritySupported && settings.isDisableReferentialIntegrity());
        this.disableReferentialIntegrity = UIUtils.createCheckbox((Composite)loadSettings, (String)DTUIMessages.database_consumer_wizard_disable_referential_integrity_label, (String)this.disableReferentialIntegrityCheckboxTooltip, (boolean)settings.isDisableReferentialIntegrity(), (int)2);
        this.disableReferentialIntegrity.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                settings.setDisableReferentialIntegrity(this.this$0.disableReferentialIntegrity.getSelection());
            }
        });
        this.disableReferentialIntegrity.setEnabled(this.isDisablingReferentialIntegritySupported);
        UIUtils.createControlLabel((Composite)loadSettings, (String)DTUIMessages.database_consumer_wizard_on_duplicate_key_insert_method_text);
        this.onDuplicateKeyInsertMethods = new Combo(loadSettings, 12);
        this.onDuplicateKeyInsertMethods.setLayoutData((Object)new GridData(768));
        this.onDuplicateKeyInsertMethods.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                int selIndex = this.this$0.onDuplicateKeyInsertMethods.getSelectionIndex();
                if (selIndex > 0 && !CommonUtils.isEmpty(this.this$0.availableInsertMethodsDescriptors)) {
                    SQLDialectInsertReplaceMethod methodDescriptor = this.this$0.availableInsertMethodsDescriptors.get(selIndex - 1);
                    settings.setOnDuplicateKeyInsertMethodId(methodDescriptor.getId());
                } else {
                    settings.setOnDuplicateKeyInsertMethodId(this.this$0.onDuplicateKeyInsertMethods.getText());
                }
            }
        });
        Link urlLabel = UIUtils.createLink((Composite)loadSettings, (String)("<a href=\"" + HelpUtils.getHelpExternalReference((String)"Data-Import-and-Replace") + "\">" + DTUIMessages.database_consumer_wizard_link_label_replace_method_wiki + "</a>"), (SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Data-Import-and-Replace"));
            }
        });
        urlLabel.setLayoutData((Object)new GridData(4, 2, false, false, 2, 1));
        this.logInsertQueriesCheck = UIUtils.createCheckbox((Composite)loadSettings, (String)DTUIMessages.database_consumer_wizard_log_insert_queries_check, (String)DTUIMessages.database_consumer_wizard_log_insert_queries_check_tip, (boolean)settings.isEnableQmLogging(), (int)4);
        this.logInsertQueriesCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> settings.setEnableQmLogging(this.logInsertQueriesCheck.getSelection())));
        Composite generalSettings = UIUtils.createTitledComposite((Composite)composite, (String)DTUIMessages.database_consumer_wizard_general_group_label, (int)1, (int)34);
        final Button newConnectionCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_new_connection, null, (boolean)settings.isOpenNewConnections(), (int)4);
        newConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(newConnectionCheckbox.getSelection());
            }
        });
        final Button useTransactionsCheck = UIUtils.createCheckbox((Composite)generalSettings, (String)DTUIMessages.database_consumer_wizard_transactions_checkbox_label, null, (boolean)settings.isUseTransactions(), (int)4);
        useTransactionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseTransactions(useTransactionsCheck.getSelection());
            }
        });
        final Button showTableCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTUIMessages.database_consumer_wizard_table_checkbox_label, (boolean)settings.isOpenTableOnFinish());
        showTableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenTableOnFinish(showTableCheckbox.getSelection());
            }
        });
        final Button showFinalMessageCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTUIMessages.database_consumer_wizard_final_message_checkbox_label, (boolean)((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage());
        showFinalMessageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                ((DataTransferWizard)this.this$0.getWizard()).getSettings().setShowFinalMessage(showFinalMessageCheckbox.getSelection());
            }
        });
        DataTransferRegistry dataTransferRegistry = DataTransferRegistry.getInstance();
        UIPropertyConfiguratorRegistry configuratorRegistry = UIPropertyConfiguratorRegistry.getInstance();
        for (DataTransferEventProcessorDescriptor descriptor : dataTransferRegistry.getEventProcessors("databaseTransferConsumer")) {
            try {
                UIPropertyConfiguratorDescriptor configuratorDescriptor = configuratorRegistry.getDescriptor(descriptor.getType().getImplName());
                IDataTransferEventProcessorConfigurator configurator = (IDataTransferEventProcessorConfigurator)configuratorDescriptor.createConfigurator();
                DatabaseConsumerPageLoadSettings databaseConsumerPageLoadSettings = this;
                this.processors.put(descriptor.getId(), new EventProcessorComposite<DatabaseConsumerSettings>(() -> databaseConsumerPageLoadSettings.updatePageCompletion(), generalSettings, settings, descriptor, configurator));
            }
            catch (Exception e2) {
                log.error((Object)"Can't create event processor", (Throwable)e2);
            }
        }
        Composite performanceSettings = UIUtils.createTitledComposite((Composite)composite, (String)DTUIMessages.database_consumer_wizard_performance_group_label, (int)4, (int)34);
        Text commitAfterEdit = UIUtils.createLabelText((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_commit_spinner_label, (String)String.valueOf(settings.getCommitAfterRows()), (int)2048);
        commitAfterEdit.addModifyListener(e -> settings.setCommitAfterRows(CommonUtils.toInt((Object)commitAfterEdit.getText())));
        GridData gd = new GridData(32, 2, false, false, 3, 1);
        gd.widthHint = UIUtils.getFontHeight((Control)commitAfterEdit) * 6;
        commitAfterEdit.setLayoutData((Object)gd);
        final Button useMultiRowInsert = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_checkbox_multi_insert_label, (String)DTUIMessages.database_consumer_wizard_checkbox_multi_insert_description, (boolean)settings.isUseMultiRowInsert(), (int)1);
        if (this.useBatchCheck != null && (!this.useBatchCheck.isDisposed() && this.useBatchCheck.getSelection() || this.useBatchCheck.isDisposed() && settings.isDisableUsingBatches())) {
            this.disableButton(useMultiRowInsert);
        }
        useMultiRowInsert.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                settings.setUseMultiRowInsert(useMultiRowInsert.getSelection());
                if (this.this$0.multiRowInsertBatch != null) {
                    if (!useMultiRowInsert.getSelection()) {
                        this.this$0.multiRowInsertBatch.setEnabled(false);
                    } else if (!this.this$0.multiRowInsertBatch.getEnabled()) {
                        this.this$0.multiRowInsertBatch.setEnabled(true);
                    }
                }
            }
        });
        this.multiRowInsertBatch = new Text(performanceSettings, 2048);
        this.multiRowInsertBatch.setToolTipText(DTUIMessages.database_consumer_wizard_spinner_multi_insert_batch_size);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.multiRowInsertBatch.setLayoutData((Object)gd);
        this.multiRowInsertBatch.setText(String.valueOf(settings.getMultiRowInsertBatch()));
        if (!useMultiRowInsert.getSelection() || this.buttonIsAvailable(this.useBatchCheck) && this.useBatchCheck.getSelection()) {
            this.multiRowInsertBatch.setEnabled(false);
        }
        this.multiRowInsertBatch.addModifyListener(e -> settings.setMultiRowInsertBatch(CommonUtils.toInt((Object)this.multiRowInsertBatch.getText())));
        if (settings.getContainer() != null && settings.getContainer().getDataSource().getInfo().supportsStatementBinding()) {
            this.skipBindValues = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_checkbox_multi_insert_skip_bind_values_label, (String)DTUIMessages.database_consumer_wizard_checkbox_multi_insert_skip_bind_values_description, (boolean)settings.isSkipBindValues(), (int)4);
            this.skipBindValues.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    settings.setSkipBindValues(this.this$0.skipBindValues.getSelection());
                }
            });
        } else {
            settings.setSkipBindValues(false);
        }
        this.useBatchCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_disable_import_batches_label, (String)DTUIMessages.database_consumer_wizard_disable_import_batches_description, (boolean)settings.isDisableUsingBatches(), (int)4);
        this.useBatchCheck.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                settings.setDisableUsingBatches(this.this$0.useBatchCheck.getSelection());
                if (this.this$0.useBatchCheck.getSelection()) {
                    this.this$0.disableButton(useMultiRowInsert);
                    settings.setUseMultiRowInsert(false);
                    this.this$0.multiRowInsertBatch.setEnabled(false);
                    if (this.this$0.buttonIsAvailable(this.this$0.ignoreDuplicateRows)) {
                        if (this.this$0.buttonIsAvailable(this.this$0.useBulkLoadCheck)) {
                            if (!this.this$0.useBulkLoadCheck.getSelection()) {
                                this.this$0.ignoreDuplicateRows.setEnabled(true);
                            }
                        } else {
                            this.this$0.ignoreDuplicateRows.setEnabled(true);
                        }
                    }
                } else if (!this.this$0.useBatchCheck.getSelection()) {
                    if (!useMultiRowInsert.getEnabled()) {
                        useMultiRowInsert.setEnabled(true);
                    }
                    if (this.this$0.buttonIsAvailable(this.this$0.ignoreDuplicateRows) && this.this$0.ignoreDuplicateRows.getEnabled()) {
                        this.this$0.disableButton(this.this$0.ignoreDuplicateRows);
                        settings.setIgnoreDuplicateRows(false);
                    }
                }
            }
        });
        this.ignoreDuplicateRows = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_ignore_duplicate_rows_label, (String)DTUIMessages.database_consumer_wizard_ignore_duplicate_rows_tip, (boolean)settings.isIgnoreDuplicateRows(), (int)4);
        if (this.buttonIsAvailable(this.useBatchCheck)) {
            boolean canIgnoreDuplicateRows = this.useBatchCheck.getSelection() && !settings.isUseBulkLoad();
            this.ignoreDuplicateRows.setEnabled(canIgnoreDuplicateRows);
            if (!canIgnoreDuplicateRows) {
                this.ignoreDuplicateRows.setSelection(false);
                settings.setIgnoreDuplicateRows(false);
            }
        }
        this.ignoreDuplicateRows.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                settings.setIgnoreDuplicateRows(this.this$0.ignoreDuplicateRows.getSelection());
            }
        });
        this.useBulkLoadCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_use_bulk_load_label, (String)DTUIMessages.database_consumer_wizard_use_bulk_load_description, (boolean)settings.isUseBulkLoad(), (int)4);
        this.useBulkLoadCheck.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DatabaseConsumerPageLoadSettings this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                boolean checkSelection = this.this$0.useBulkLoadCheck.getSelection();
                settings.setUseBulkLoad(checkSelection);
                if (this.this$0.buttonIsAvailable(this.this$0.ignoreDuplicateRows)) {
                    if (checkSelection) {
                        this.this$0.disableButton(this.this$0.ignoreDuplicateRows);
                        settings.setIgnoreDuplicateRows(false);
                    } else if (this.this$0.buttonIsAvailable(this.this$0.useBatchCheck) && this.this$0.useBatchCheck.getSelection()) {
                        this.this$0.ignoreDuplicateRows.setEnabled(true);
                    }
                }
                this.this$0.onDuplicateKeyInsertMethods.setEnabled(!checkSelection);
            }
        });
        this.setControl((Control)composite);
    }

    private boolean buttonIsAvailable(Button button) {
        return button != null && !button.isDisposed();
    }

    private void disableButton(Button button) {
        button.setEnabled(false);
        button.setSelection(false);
    }

    private void loadUISettingsForDisableReferentialIntegrityCheckbox() {
        this.isDisablingReferentialIntegritySupported = false;
        this.disableReferentialIntegrityCheckboxTooltip = "";
        ArrayList<DBPReferentialIntegrityController> riControllers = new ArrayList<DBPReferentialIntegrityController>();
        for (DatabaseMappingContainer mappingContainer : this.getSettings().getDataMappings().values()) {
            if (!(mappingContainer.getTarget() instanceof DBPReferentialIntegrityController)) continue;
            riControllers.add((DBPReferentialIntegrityController)mappingContainer.getTarget());
        }
        if (!riControllers.isEmpty()) {
            try {
                ((DataTransferWizard)this.getWizard()).getRunnableContext().run(false, false, monitor -> {
                    LinkedHashSet<String> statements = new LinkedHashSet<String>();
                    for (DBPReferentialIntegrityController controller : riControllers) {
                        try {
                            if (!controller.supportsChangingReferentialIntegrity(monitor)) continue;
                            this.isDisablingReferentialIntegritySupported = true;
                            statements.add(controller.getChangeReferentialIntegrityStatement(monitor, false));
                            statements.add(controller.getChangeReferentialIntegrityStatement(monitor, true));
                        }
                        catch (DBException e) {
                            log.debug((Object)"Unexpected error when calculating UI options for 'Disable referential integrity' checkbox", (Throwable)e);
                        }
                    }
                    if (!statements.isEmpty()) {
                        StringJoiner tooltip = new StringJoiner(System.lineSeparator(), DTUIMessages.database_consumer_wizard_disable_referential_integrity_tip_start + System.lineSeparator(), "");
                        statements.forEach(tooltip::add);
                        this.disableReferentialIntegrityCheckboxTooltip = tooltip.toString();
                    }
                });
            }
            catch (InvocationTargetException e) {
                log.debug((Object)"Unexpected error", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private DatabaseConsumerSettings getSettings() {
        return ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
    }

    public void activatePage() {
        DatabaseConsumerSettings settings = this.getSettings();
        for (Map.Entry<String, EventProcessorComposite<?>> processor : this.processors.entrySet()) {
            processor.getValue().setProcessorEnabled(settings.hasEventProcessor(processor.getKey()));
            processor.getValue().loadSettings(settings.getEventProcessorSettings(processor.getKey()));
        }
        this.updatePageCompletion();
        this.updateControlsEnablement();
        UIUtils.syncExec(this::loadSettings);
    }

    private void loadSettings() {
        DatabaseConsumerSettings settings = this.getSettings();
        if (settings.isTruncateBeforeLoad() && !this.confirmDataTruncate()) {
            this.truncateTargetTable.setSelection(false);
            settings.setTruncateBeforeLoad(false);
        }
        if (this.buttonIsAvailable(this.useBulkLoadCheck)) {
            DBPDataSource dataSource;
            DBPDataSource dBPDataSource = dataSource = settings.getContainer() == null ? null : settings.getContainer().getDataSource();
            if (DBUtils.getAdapter(DBSDataBulkLoader.class, (Object)dataSource) == null) {
                this.disableButton(this.useBulkLoadCheck);
                settings.setUseBulkLoad(false);
            }
        }
        this.loadInsertMethods();
        this.onDuplicateKeyInsertMethods.setEnabled(!this.useBulkLoadCheck.getSelection());
        this.logInsertQueriesCheck.setSelection(settings.isEnableQmLogging());
    }

    private boolean confirmDataTruncate() {
        Shell shell = this.getContainer().getShell();
        if (shell == null) {
            return true;
        }
        if (shell.isVisible() || this.getSettings().isTruncateBeforeLoad()) {
            String tableNames = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes().stream().map(pipe -> pipe.getConsumer() == null ? "" : pipe.getConsumer().getObjectName()).collect(Collectors.joining(","));
            String checkbox_question = NLS.bind((String)DTUIMessages.database_consumer_wizard_truncate_checkbox_question, (Object)tableNames);
            return UIUtils.confirmAction((Shell)shell, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_title, (String)checkbox_question, (DBPImage)DBIcon.STATUS_WARNING);
        }
        return true;
    }

    private void loadInsertMethods() {
        SQLDialectMetadata dialectDescriptor;
        DatabaseConsumerSettings settings = this.getSettings();
        DBSObjectContainer container = settings.getContainer();
        if (container == null) {
            return;
        }
        DBPDataSource dataSource = container.getDataSource();
        List insertMethodsDescriptors = null;
        if (dataSource != null && (dialectDescriptor = DBWorkbench.getPlatform().getSQLDialectRegistry().getDialect(dataSource.getSQLDialect().getDialectId())) != null) {
            insertMethodsDescriptors = dialectDescriptor.getSupportedInsertReplaceMethodsDescriptors();
        }
        this.onDuplicateKeyInsertMethods.removeAll();
        this.onDuplicateKeyInsertMethods.add("<None>");
        if (!CommonUtils.isEmpty(insertMethodsDescriptors)) {
            boolean emptyButton = true;
            for (SQLDialectInsertReplaceMethod insertMethod : insertMethodsDescriptors) {
                this.onDuplicateKeyInsertMethods.add(insertMethod.getLabel());
                if (!insertMethod.getId().equals(settings.getOnDuplicateKeyInsertMethodId())) continue;
                this.onDuplicateKeyInsertMethods.setText(insertMethod.getLabel());
                emptyButton = false;
            }
            if (emptyButton) {
                this.onDuplicateKeyInsertMethods.setText("<None>");
                if (!CommonUtils.isEmpty((String)settings.getOnDuplicateKeyInsertMethodId())) {
                    settings.setOnDuplicateKeyInsertMethodId(null);
                }
            }
        } else {
            this.onDuplicateKeyInsertMethods.setText("<None>");
            this.onDuplicateKeyInsertMethods.setEnabled(false);
            settings.setOnDuplicateKeyInsertMethodId(null);
        }
        this.availableInsertMethodsDescriptors = insertMethodsDescriptors;
    }

    public void deactivatePage() {
        DatabaseConsumerSettings settings = this.getSettings();
        for (Map.Entry<String, EventProcessorComposite<?>> processor : this.processors.entrySet()) {
            EventProcessorComposite<?> configurator = processor.getValue();
            if (!configurator.isProcessorEnabled() || !configurator.isProcessorApplicable() || !configurator.isProcessorComplete()) continue;
            configurator.saveSettings(settings.getEventProcessorSettings(processor.getKey()));
        }
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        for (EventProcessorComposite<?> processor : this.processors.values()) {
            if (!processor.isProcessorApplicable() || !processor.isProcessorEnabled() || processor.isProcessorComplete()) continue;
            this.setErrorMessage(NLS.bind((String)DTMessages.data_transfer_wizard_output_event_processor_error_incomplete_configuration, (Object)processor.getDescriptor().getLabel()));
            return false;
        }
        return true;
    }

    public boolean isPageApplicable() {
        return this.isConsumerOfType(DatabaseTransferConsumer.class);
    }

    private void updateControlsEnablement() {
        for (EventProcessorComposite<?> processor : this.processors.values()) {
            processor.setProcessorAvailable(processor.isProcessorApplicable());
        }
    }
}

