/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.launcher;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Map;

class LauncherUtils {
    private static final Map<Character, String> CHARS_TO_ESCAPE = Map.of(Character.valueOf('\b'), "\\b", Character.valueOf('\n'), "\\n", Character.valueOf('\t'), "\\t", Character.valueOf('\f'), "\\f", Character.valueOf('\r'), "\\r", Character.valueOf('\"'), "\\\"", Character.valueOf('\\'), "\\\\", Character.valueOf('/'), "\\/");

    LauncherUtils() {
    }

    static File toFileURL(String spec) {
        try {
            return new File(new URI(spec));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return new File(spec.substring(5));
        }
    }

    static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        Object file = url.getFile();
        if (trailingSlash == ((String)file).endsWith("/")) {
            return url;
        }
        file = trailingSlash ? (String)file + "/" : ((String)file).substring(0, ((String)file).length() - 1);
        return new URL(url.getProtocol(), url.getHost(), (String)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canWrite(File installDir) {
        if (!installDir.isDirectory()) {
            return false;
        }
        if (Files.isWritable(installDir.toPath())) {
            return true;
        }
        File fileTest = null;
        try {
            fileTest = File.createTempFile("writableArea", ".dll", installDir);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    public static String escape(String original) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            char c = original.charAt(i);
            if (CHARS_TO_ESCAPE.containsKey(Character.valueOf(c))) {
                escaped.append(CHARS_TO_ESCAPE.get(Character.valueOf(c)));
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }
}

