/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.local;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetColumn;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class LocalResultSet<SOURCE_STMT extends DBCStatement>
extends AbstractResultSet<DBCSession, SOURCE_STMT> {
    private final List<DBCAttributeMetaData> metaColumns = new ArrayList<DBCAttributeMetaData>();
    protected final List<Object[]> rows = new ArrayList<Object[]>();
    protected int curPosition = -1;

    public LocalResultSet(@NotNull DBCSession session, @NotNull SOURCE_STMT statement) {
        super(session, statement);
    }

    @Override
    public Object getAttributeValue(int index) throws DBCException {
        Object[] row = this.rows.get(this.curPosition);
        if (index >= row.length) {
            throw new DBCException("Attribute index out of range (" + index + "/" + row.length + ")");
        }
        return row[index];
    }

    @Override
    @Nullable
    public Object getAttributeValue(String name) throws DBCException {
        for (int i = 0; i < this.metaColumns.size(); ++i) {
            if (!this.metaColumns.get(i).getName().equals(name)) continue;
            return this.getAttributeValue(i);
        }
        throw new DBCException("Bad attribute name: " + name);
    }

    @Override
    public boolean nextRow() {
        if (this.curPosition + 1 >= this.rows.size()) {
            return false;
        }
        ++this.curPosition;
        return true;
    }

    @Override
    public boolean moveTo(int position) throws DBCException {
        if (position < 0 || position >= this.rows.size()) {
            return false;
        }
        this.curPosition = position;
        return true;
    }

    @Override
    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        return new LocalResultSetMeta(this.metaColumns);
    }

    @Override
    public Object getFeature(String name) {
        if (name.equals("local")) {
            return true;
        }
        return super.getFeature(name);
    }

    @Override
    public void close() {
        this.curPosition = -1;
        this.rows.clear();
        this.metaColumns.clear();
    }

    public int getColumnCount() {
        return this.metaColumns.size();
    }

    public DBCAttributeMetaData addColumn(String label, DBPDataKind dataKind) {
        LocalResultSetColumn column = new LocalResultSetColumn((DBCResultSet)this, this.metaColumns.size(), label, dataKind);
        this.metaColumns.add(column);
        return column;
    }

    public DBCAttributeMetaData addColumn(String label, DBSTypedObject typedObject) {
        LocalResultSetColumn column = new LocalResultSetColumn((DBCResultSet)this, this.metaColumns.size(), label, typedObject);
        this.metaColumns.add(column);
        return column;
    }

    protected void addColumn(@NotNull LocalResultSetColumn column) {
        this.metaColumns.add(column);
    }

    @NotNull
    protected DBCAttributeMetaData getMetaColumn(int index) {
        return this.metaColumns.get(index);
    }

    public void addRow(Object ... values) {
        this.rows.add(values);
    }
}

