/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.data.AbstractContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.ContentUtils;

public class StringContent
extends AbstractContent {
    private StringContentStorage storage;

    public StringContent(DBCExecutionContext executionContext, String data) {
        super(executionContext);
        this.storage = new StringContentStorage(data);
    }

    @Override
    public long getContentLength() throws DBCException {
        return this.storage.getContentLength();
    }

    @Override
    @NotNull
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public String getDisplayString(@NotNull DBDDisplayFormat format) {
        return this.storage.getCachedValue();
    }

    @Override
    public DBDContentStorage getContents(@NotNull DBRProgressMonitor monitor) throws DBCException {
        return this.storage;
    }

    @Override
    public boolean updateContents(@NotNull DBRProgressMonitor monitor, @NotNull DBDContentStorage storage) throws DBException {
        try (Reader reader = storage.getContentReader();){
            StringWriter sw = new StringWriter((int)storage.getContentLength());
            ContentUtils.copyStreams(reader, storage.getContentLength(), sw, monitor);
            this.storage = new StringContentStorage(sw.toString());
        }
        catch (IOException e) {
            throw new DBCException("IO error while reading content", e);
        }
        return true;
    }

    @Override
    public String getRawValue() {
        return this.storage.getCachedValue();
    }

    @Override
    public boolean isNull() {
        return this.storage.getCachedValue() == null;
    }

    @Override
    public void release() {
    }
}

