/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StringContentStorage
implements DBDContentStorage,
DBDContentCached {
    private static final Log log = Log.getLog(StringContentStorage.class);
    private String data;

    public StringContentStorage(String data) {
        this.data = data;
    }

    @Override
    public InputStream getContentStream() throws IOException {
        return new ByteArrayInputStream(this.data.getBytes(GeneralUtils.getDefaultFileEncoding()));
    }

    @Override
    public Reader getContentReader() throws IOException {
        return new StringReader(CommonUtils.notEmpty((String)this.data));
    }

    @Override
    public long getContentLength() {
        return this.data == null ? 0L : (long)this.data.length();
    }

    @Override
    public String getCharset() {
        return GeneralUtils.getDefaultFileEncoding();
    }

    @Override
    public DBDContentStorage cloneStorage(DBRProgressMonitor monitor) throws IOException {
        return new StringContentStorage(this.data);
    }

    @Override
    public void release() {
        this.data = null;
    }

    public static StringContentStorage createFromReader(Reader stream, long contentLength) throws IOException {
        int count;
        if (contentLength > 0x3FFFFFFFL) {
            throw new IOException("Too big content length for memory storage: " + contentLength);
        }
        StringBuilder buffer = new StringBuilder((int)contentLength);
        char[] charBuffer = new char[10000];
        while ((count = stream.read(charBuffer)) > 0) {
            buffer.append(charBuffer, 0, count);
        }
        if ((long)buffer.length() != contentLength) {
            log.warn("Actual content length (" + buffer.length() + ") is less than declared: " + contentLength);
        }
        return new StringContentStorage(buffer.toString());
    }

    @NotNull
    public static StringContentStorage createFromReader(Reader stream) throws IOException {
        char[] charBuffer;
        int count;
        StringBuilder buffer = new StringBuilder(1000);
        while ((count = stream.read(charBuffer = new char[10000])) > 0) {
            buffer.append(charBuffer, 0, count);
        }
        return new StringContentStorage(buffer.toString());
    }

    @Override
    public String getCachedValue() {
        return this.data;
    }
}

