/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.stm;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.stm.STMParserOverrides;

public interface STMTreeNode
extends Tree {
    public void fixup(@NotNull STMParserOverrides var1);

    default public int getNodeKindId() {
        return -1;
    }

    public int getAtnState();

    @NotNull
    public String getNodeName();

    @NotNull
    public Interval getRealInterval();

    @NotNull
    public String getTextContent();

    @NotNull
    public String getText();

    @Nullable
    default public STMTreeNode getParentNode() {
        STMTreeNode parent;
        Tree tree = this.getParent();
        return tree instanceof STMTreeNode ? (parent = (STMTreeNode)tree) : null;
    }

    default public STMTreeNode getChildNode(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean hasErrorChildren();

    @Nullable
    default public STMTreeNode findFirstNonErrorChild() {
        if (this.hasErrorChildren()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                STMTreeNode cn = this.getChildNode(i);
                if (cn == null || cn instanceof ErrorNode) continue;
                return cn;
            }
        } else if (this.getChildCount() > 0) {
            return this.getChildNode(0);
        }
        return null;
    }

    @Nullable
    default public STMTreeNode findLastNonErrorChild() {
        if (this.hasErrorChildren()) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                STMTreeNode cn = this.getChildNode(i);
                if (cn == null || cn instanceof ErrorNode) continue;
                return cn;
            }
        } else if (this.getChildCount() > 0) {
            return this.getChildNode(this.getChildCount() - 1);
        }
        return null;
    }

    @Nullable
    default public STMTreeNode findFirstChildOfName(@NotNull String nodeName) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            STMTreeNode cn = this.getChildNode(i);
            if (cn == null || !cn.getNodeName().equals(nodeName)) continue;
            return cn;
        }
        return null;
    }

    @Nullable
    default public STMTreeNode findLastChildOfName(@NotNull String nodeName) {
        for (int i = this.getChildCount(); i >= 0; --i) {
            STMTreeNode cn = this.getChildNode(i);
            if (cn == null || !cn.getNodeName().equals(nodeName)) continue;
            return cn;
        }
        return null;
    }

    @NotNull
    default public List<STMTreeNode> getChildren() {
        return new AbstractList<STMTreeNode>(){

            @Override
            public STMTreeNode get(int index) {
                return STMTreeNode.this.getChildNode(index);
            }

            @Override
            public int size() {
                return STMTreeNode.this.getChildCount();
            }
        };
    }

    @NotNull
    default public List<STMTreeNode> findChildrenOfName(@NotNull String nodeName) {
        ArrayList<STMTreeNode> children = new ArrayList<STMTreeNode>(this.getChildCount());
        for (int i = 0; i < this.getChildCount(); ++i) {
            STMTreeNode cn = this.getChildNode(i);
            if (cn == null || !cn.getNodeName().equals(nodeName)) continue;
            children.add(cn);
        }
        return children;
    }

    @NotNull
    default public List<STMTreeNode> findNonErrorChildren() {
        if (this.hasErrorChildren()) {
            ArrayList<STMTreeNode> children = new ArrayList<STMTreeNode>(this.getChildCount());
            for (int i = 0; i < this.getChildCount(); ++i) {
                STMTreeNode cn = this.getChildNode(i);
                if (cn == null || cn instanceof ErrorNode) continue;
                children.add(cn);
            }
            return children;
        }
        return this.getChildren();
    }
}

