/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.office.export;

import java.awt.Color;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.data.office.export.Worksheet;
import org.jkiss.dbeaver.data.office.export.WorksheetUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeDecorator;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IAppendableDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterXLSX
extends StreamExporterAbstract
implements IAppendableDataExporter {
    private static final Log log = Log.getLog(DataExporterXLSX.class);
    private static final String PROP_HEADER = "header";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_ROWNUMBER = "rownumber";
    private static final String PROP_BORDER = "border";
    private static final String PROP_HEADER_FONT = "headerfont";
    private static final String BINARY_FIXED = "[BINARY]";
    private static final String PROP_TRUESTRING = "trueString";
    private static final String PROP_FALSESTRING = "falseString";
    private static final String PROP_TRIM_STRINGS = "trimString";
    private static final String PROP_EXPORT_SQL = "exportSql";
    private static final String PROP_SPLIT_SQLTEXT = "splitSqlText";
    private static final String PROP_SPLIT_BYROWCOUNT = "splitByRowCount";
    private static final String PROP_SPLIT_BYCOL = "splitByColNum";
    private static final String PROP_DATE_FORMAT = "dateFormat";
    private static final String PROP_APPEND_STRATEGY = "appendStrategy";
    private static final String PROP_USE_DEFAULT_SPREADSHEET_NAMES = "useDefaultSpreadsheetNames";
    private static final int EXCEL2007MAXROWS = 1048575;
    private static final int EXCEL_MAX_CELL_CHARACTERS = Short.MAX_VALUE;
    private static final int MINIMUM_LENGTH = 2560;
    private static final int ROW_WINDOW = 100;
    private static final Date EXCEL_MIN_DATE = new GregorianCalendar(1900, 0, 1).getTime();
    private static final String DEFAULT_DATE_FORMAT = "MM/dd/yy";
    private String nullString;
    private String dateFormatString;
    private DBDAttributeBinding[] columns;
    private DBDAttributeDecorator decorator;
    private SXSSFWorkbook wb;
    private HeaderFormat headerFormat = HeaderFormat.LABEL;
    private boolean rowNumber = false;
    private String boolTrue = "true";
    private String boolFalse = "false";
    private boolean booleRedefined;
    private boolean trimStrings;
    private boolean exportSql = false;
    private boolean splitSqlText = false;
    private AppendStrategy appendStrategy = AppendStrategy.CREATE_NEW_SHEETS;
    private String exportTableName = "CustomQuery";
    private int splitByRowCount = 1048575;
    private int splitByCol = 0;
    private int rowCount = 0;
    private int sheetIndex = 0;
    private XSSFCellStyle style;
    private XSSFCellStyle styleDate;
    private XSSFCellStyle styleHeader;
    private HashMap<Object, Worksheet> worksheets;

    public static Map<String, Object> getDefaultProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(PROP_ROWNUMBER, false);
        properties.put(PROP_BORDER, "THIN");
        properties.put(PROP_HEADER, HeaderFormat.LABEL.value);
        properties.put(PROP_NULL_STRING, null);
        properties.put(PROP_HEADER_FONT, "BOLD");
        properties.put(PROP_TRUESTRING, "true");
        properties.put(PROP_FALSESTRING, "false");
        properties.put(PROP_TRIM_STRINGS, "false");
        properties.put(PROP_EXPORT_SQL, false);
        properties.put(PROP_SPLIT_SQLTEXT, false);
        properties.put(PROP_SPLIT_BYROWCOUNT, 1048575);
        properties.put(PROP_SPLIT_BYCOL, 0);
        properties.put(PROP_DATE_FORMAT, "");
        properties.put(PROP_APPEND_STRATEGY, AppendStrategy.CREATE_NEW_SHEETS.value);
        properties.put(PROP_USE_DEFAULT_SPREADSHEET_NAMES, true);
        return properties;
    }

    public void init(IStreamDataExporterSite site) throws DBException {
        Map properties = site.getProperties();
        Object nullStringProp = properties.get(PROP_NULL_STRING);
        this.nullString = nullStringProp == null ? null : nullStringProp.toString();
        this.headerFormat = HeaderFormat.of(CommonUtils.toString(properties.get(PROP_HEADER)));
        this.rowNumber = CommonUtils.getBoolean(properties.get(PROP_ROWNUMBER), (boolean)false);
        this.boolTrue = CommonUtils.toString(properties.get(PROP_TRUESTRING), (String)Boolean.TRUE.toString());
        this.boolFalse = CommonUtils.toString(properties.get(PROP_FALSESTRING), (String)Boolean.FALSE.toString());
        if (!Boolean.TRUE.toString().equals(this.boolTrue) || !Boolean.FALSE.toString().equals(this.boolFalse)) {
            this.booleRedefined = true;
        }
        this.trimStrings = CommonUtils.getBoolean(properties.get(PROP_TRIM_STRINGS), (boolean)false);
        this.exportSql = CommonUtils.getBoolean(properties.get(PROP_EXPORT_SQL), (boolean)false);
        this.splitSqlText = CommonUtils.getBoolean(properties.get(PROP_SPLIT_SQLTEXT), (boolean)false);
        this.splitByRowCount = CommonUtils.toInt(properties.get(PROP_SPLIT_BYROWCOUNT), (int)1048575);
        this.splitByCol = CommonUtils.toInt(properties.get(PROP_SPLIT_BYCOL), (int)0);
        this.appendStrategy = AppendStrategy.of(CommonUtils.toString(properties.get(PROP_APPEND_STRATEGY)));
        if (this.wb == null) {
            this.wb = new SXSSFWorkbook(100);
        }
        this.worksheets = new HashMap(1);
        this.styleHeader = (XSSFCellStyle)this.wb.createCellStyle();
        BorderStyle border = (BorderStyle)CommonUtils.valueOf(BorderStyle.class, (String)CommonUtils.toString(properties.get(PROP_BORDER), (String)BorderStyle.THIN.name()), (Enum)BorderStyle.THIN);
        FontStyleProp fontStyle = (FontStyleProp)CommonUtils.valueOf(FontStyleProp.class, (String)CommonUtils.toString(properties.get(PROP_HEADER_FONT), (String)FontStyleProp.BOLD.name()), (Enum)FontStyleProp.BOLD);
        this.styleHeader.setBorderTop(border);
        this.styleHeader.setBorderBottom(border);
        this.styleHeader.setBorderLeft(border);
        this.styleHeader.setBorderRight(border);
        XSSFFont fontBold = (XSSFFont)this.wb.createFont();
        switch (fontStyle.ordinal()) {
            case 1: {
                fontBold.setBold(true);
                break;
            }
            case 2: {
                fontBold.setItalic(true);
                break;
            }
            case 3: {
                fontBold.setStrikeout(true);
                break;
            }
            case 4: {
                fontBold.setUnderline((byte)3);
                break;
            }
        }
        this.styleHeader.setFont((Font)fontBold);
        this.style = (XSSFCellStyle)this.wb.createCellStyle();
        this.style.setBorderTop(border);
        this.style.setBorderBottom(border);
        this.style.setBorderLeft(border);
        this.style.setBorderRight(border);
        this.styleDate = (XSSFCellStyle)this.wb.createCellStyle();
        this.styleDate.setBorderTop(border);
        this.styleDate.setBorderBottom(border);
        this.styleDate.setBorderLeft(border);
        this.styleDate.setBorderRight(border);
        this.rowCount = 0;
        this.sheetIndex = 0;
        this.dateFormatString = CommonUtils.toString(properties.get(PROP_DATE_FORMAT), (String)DEFAULT_DATE_FORMAT);
        this.styleDate.setDataFormat(this.wb.getCreationHelper().createDataFormat().getFormat(this.dateFormatString));
        super.init(site);
    }

    public void dispose() {
        try {
            if (this.exportSql && this.wb != null) {
                try {
                    SXSSFSheet sh = this.wb.createSheet();
                    if (this.splitSqlText) {
                        String[] sqlText = this.getSite().getSource().getName().split("\n", this.wb.getSpreadsheetVersion().getMaxRows());
                        int sqlRownum = 0;
                        for (String s : sqlText) {
                            Row row = sh.createRow(sqlRownum);
                            Cell newcell = row.createCell(0);
                            newcell.setCellValue(s);
                            ++sqlRownum;
                        }
                    } else {
                        Row row = sh.createRow(0);
                        Cell newcell = row.createCell(0);
                        newcell.setCellValue(this.getSite().getSource().getName());
                    }
                    sh = null;
                }
                catch (Exception e) {
                    log.error((Object)"Dispose error", (Throwable)e);
                }
            }
            if (this.wb != null) {
                this.wb.write(this.getSite().getOutputStream());
                this.wb.close();
                this.wb.dispose();
            }
        }
        catch (IOException e) {
            log.error((Object)"Dispose error", (Throwable)e);
        }
        this.wb = null;
        if (!CommonUtils.isEmpty(this.worksheets)) {
            for (Worksheet w : this.worksheets.values()) {
                w.dispose();
            }
            this.worksheets.clear();
        }
        super.dispose();
    }

    public void exportHeader(DBCSession session) throws DBException {
        this.columns = this.getSite().getAttributes();
        if (this.headerFormat.hasDescription()) {
            DBSEntity srcEntity = (DBSEntity)DBUtils.getAdapter(DBSEntity.class, (Object)this.getSite().getSource());
            DBExecUtils.bindAttributes((DBCSession)session, (DBSEntity)srcEntity, null, (DBDAttributeBinding[])this.columns, null);
        }
        this.decorator = (DBDAttributeDecorator)GeneralUtils.adapt((Object)this.getSite().getSource(), DBDAttributeDecorator.class);
        if (this.columns != null && this.columns.length > 0) {
            this.exportTableName = DTUtils.getTableName((DBPDataSource)this.columns[0].getDataSource(), (DBPNamedObject)this.getSite().getSource(), (boolean)true, (String)"CustomQuery");
        }
    }

    private void printHeader(DBCResultSet resultSet, Worksheet wsh) throws DBException {
        int columnsSize;
        int startCol;
        SXSSFSheet sh = (SXSSFSheet)wsh.getSh();
        if (this.appendStrategy == AppendStrategy.USE_EXISTING_SHEETS && this.getPhysicalNumberOfRows((Sheet)sh) > 0) {
            return;
        }
        boolean hasDescription = false;
        if (this.headerFormat.hasDescription()) {
            DBSEntity sourceEntity;
            boolean bindingsOk = true;
            DBDAttributeBindingMeta[] bindings = new DBDAttributeBindingMeta[this.columns.length];
            for (int i = 0; i < this.columns.length; ++i) {
                if (!(this.columns[i] instanceof DBDAttributeBindingMeta)) {
                    bindingsOk = false;
                    break;
                }
                bindings[i] = (DBDAttributeBindingMeta)this.columns[i];
            }
            if (bindingsOk && (sourceEntity = (DBSEntity)GeneralUtils.adapt((Object)this.getSite().getSource(), DBSEntity.class)) != null) {
                DBExecUtils.bindAttributes((DBCSession)resultSet.getSession(), (DBSEntity)sourceEntity, (DBCResultSet)resultSet, (DBDAttributeBinding[])bindings, null);
            }
            for (DBDAttributeBinding column : this.columns) {
                if (CommonUtils.isEmpty((String)column.getDescription())) continue;
                hasDescription = true;
                break;
            }
        }
        if (!hasDescription && !this.headerFormat.hasLabel()) {
            return;
        }
        sh.trackAllColumnsForAutoSizing();
        int n = startCol = this.rowNumber ? 1 : 0;
        if (this.headerFormat.hasLabel()) {
            SXSSFRow row = sh.createRow(wsh.getCurrentRow());
            columnsSize = this.columns.length;
            for (int i = 0; i < columnsSize; ++i) {
                DBDAttributeBinding column = this.columns[i];
                String colName = column.getLabel();
                if (CommonUtils.isEmpty((String)colName)) {
                    colName = column.getName();
                }
                Cell cell = row.createCell(i + startCol, CellType.STRING);
                cell.setCellValue(colName);
                cell.setCellStyle((CellStyle)this.styleHeader);
            }
            wsh.incRow();
        }
        if (hasDescription) {
            SXSSFRow descRow = sh.createRow(wsh.getCurrentRow());
            columnsSize = this.columns.length;
            for (int i = 0; i < columnsSize; ++i) {
                Cell descCell = descRow.createCell(i + startCol, CellType.STRING);
                String description = this.columns[i].getDescription();
                descCell.setCellValue(CommonUtils.notEmpty((String)description));
                descCell.setCellStyle((CellStyle)this.styleHeader);
                if (!CommonUtils.isNotEmpty((String)description)) continue;
                sh.autoSizeColumn(i);
            }
            wsh.incRow();
        }
        try {
            sh.flushRows();
        }
        catch (IOException e) {
            throw new DBException("Error processing header", (Throwable)e);
        }
        sh.untrackAllColumnsForAutoSizing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCellValue(Cell cell, Reader reader) throws IOException {
        try {
            int count;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[2000];
            while ((count = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, count);
            }
            cell.setCellValue(this.getPreparedString(sb.toString()));
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    private Worksheet createSheet(DBCResultSet resultSet, Object colValue) throws DBException {
        Worksheet worksheet;
        if (this.appendStrategy == AppendStrategy.USE_EXISTING_SHEETS && this.sheetIndex < this.wb.getNumberOfSheets()) {
            SXSSFSheet sheet = this.wb.getSheetAt(this.sheetIndex++);
            worksheet = new Worksheet((Sheet)sheet, colValue, this.getPhysicalNumberOfRows((Sheet)sheet));
        } else {
            SXSSFSheet sheet = CommonUtils.toBoolean(this.getSite().getProperties().get(PROP_USE_DEFAULT_SPREADSHEET_NAMES), (boolean)true) ? this.wb.createSheet() : this.wb.createSheet(WorksheetUtils.makeUniqueSheetName((Workbook)this.wb, this.exportTableName));
            worksheet = new Worksheet((Sheet)sheet, colValue, 0);
        }
        this.printHeader(resultSet, worksheet);
        return worksheet;
    }

    private Worksheet getWsh(DBCResultSet resultSet, Object[] row) throws DBException {
        Object colValue = this.splitByCol <= 0 || this.splitByCol >= this.columns.length ? "" : row[this.splitByCol];
        Worksheet w = this.worksheets.get(colValue);
        if (w == null) {
            w = this.createSheet(resultSet, colValue);
            this.worksheets.put(w.getColumnVal(), w);
        } else if (w.getCurrentRow() >= this.splitByRowCount) {
            w = this.createSheet(resultSet, colValue);
            this.worksheets.put(w.getColumnVal(), w);
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        Worksheet wsh = this.getWsh(resultSet, row);
        Row rowX = wsh.getSh().createRow(wsh.getCurrentRow());
        int startCol = 0;
        if (this.rowNumber) {
            Cell cell = rowX.createCell(startCol, CellType.NUMERIC);
            cell.setCellStyle((CellStyle)this.style);
            cell.setCellValue(String.valueOf(wsh.getCurrentRow()));
            ++startCol;
        }
        for (int i = 0; i < row.length; ++i) {
            Object content;
            DBDAttributeBinding column = this.columns[i];
            Cell cell = rowX.createCell(i + startCol, this.getCellType(column));
            cell.setCellStyle(this.getCellStyle(column, this.rowCount));
            if (DBUtils.isNullValue((Object)row[i])) {
                if (!CommonUtils.isEmpty((String)this.nullString)) {
                    cell.setCellValue(this.nullString);
                    continue;
                }
                cell.setCellValue("");
                continue;
            }
            if (row[i] instanceof DBDContent) {
                content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) {
                        cell.setCellValue("[NULL]");
                        continue;
                    }
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        this.writeCellValue(cell, cs.getContentReader());
                        continue;
                    }
                    cell.setCellValue(BINARY_FIXED);
                    continue;
                }
                finally {
                    content.release();
                }
            }
            if (row[i] instanceof Boolean) {
                if (this.booleRedefined) {
                    cell.setCellValue((Boolean)row[i] != false ? this.boolTrue : this.boolFalse);
                    continue;
                }
                cell.setCellValue(((Boolean)row[i]).booleanValue());
                continue;
            }
            if (row[i] instanceof Number) {
                cell.setCellValue(((Number)row[i]).doubleValue());
                continue;
            }
            content = row[i];
            if (content instanceof Date) {
                Date dateVal = (Date)content;
                if (dateVal.before(EXCEL_MIN_DATE)) {
                    SimpleDateFormat fmt = new SimpleDateFormat(this.dateFormatString);
                    String text = fmt.format(dateVal);
                    cell.setCellValue(text);
                    continue;
                }
                cell.setCellValue(dateVal);
                cell.setCellStyle((CellStyle)this.styleDate);
                continue;
            }
            String stringValue = super.getValueDisplayString(column, row[i]);
            cell.setCellValue(this.getPreparedString(stringValue));
        }
        wsh.incRow();
        ++this.rowCount;
    }

    private CellType getCellType(DBDAttributeBinding column) {
        switch (column.getDataKind()) {
            case NUMERIC: {
                return CellType.NUMERIC;
            }
            case BOOLEAN: {
                return CellType.BOOLEAN;
            }
            case STRING: {
                return CellType.STRING;
            }
        }
        return CellType.BLANK;
    }

    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.wb != null && this.sheetIndex > 0) {
            SXSSFSheet sheet = this.wb.getSheetAt(this.sheetIndex);
            HSSFFormulaEvaluator.evaluateAllFormulaCells((Workbook)this.wb);
            sheet.trackAllColumnsForAutoSizing();
            for (int i = 0; i < this.columns.length; ++i) {
                sheet.autoSizeColumn(i);
                if (sheet.getColumnWidth(i) >= 2560) continue;
                sheet.setColumnWidth(i, 2560);
            }
            sheet.untrackAllColumnsForAutoSizing();
        }
        if (this.rowCount == 0) {
            this.exportRow(null, null, new Object[this.columns.length]);
        }
    }

    public void importData(@NotNull IStreamDataExporterSite site) throws DBException {
        Path file = site.getOutputFile();
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            return;
        }
        try {
            this.wb = new SXSSFWorkbook(new XSSFWorkbook(Files.newInputStream(file, new OpenOption[0])));
        }
        catch (Exception e) {
            throw new DBException("Error opening workbook", (Throwable)e);
        }
    }

    public boolean shouldTruncateOutputFileBeforeExport() {
        return true;
    }

    private int getPhysicalNumberOfRows(@NotNull Sheet sheet) {
        return this.wb.getXSSFWorkbook().getSheetAt(this.wb.getSheetIndex(sheet)).getPhysicalNumberOfRows();
    }

    private String getPreparedString(@Nullable String cellValue) {
        if (CommonUtils.isNotEmpty((String)cellValue) && cellValue.length() > Short.MAX_VALUE) {
            log.warn((Object)("The string value of the row " + (this.rowCount + 1) + " was more maximum length, so it was cropped."));
            cellValue = CommonUtils.truncateString((String)cellValue, (int)Short.MAX_VALUE);
        }
        if (this.trimStrings && CommonUtils.isNotEmpty((String)cellValue)) {
            cellValue = cellValue.trim();
        }
        return cellValue;
    }

    @NotNull
    private CellStyle getCellStyle(@NotNull DBDAttributeBinding attribute, int row) {
        String bg;
        if (this.decorator != null && (bg = this.decorator.getCellBackground(attribute, row)) != null) {
            XSSFCellStyle style = this.style.copy();
            style.setFillForegroundColor(new XSSFColor(DataExporterXLSX.asColor(bg), (IndexedColorMap)new DefaultIndexedColorMap()));
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            return style;
        }
        return this.style;
    }

    @NotNull
    private static Color asColor(@NotNull String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        int r = Integer.parseInt(tokenizer.nextToken().trim());
        int g = Integer.parseInt(tokenizer.nextToken().trim());
        int b = Integer.parseInt(tokenizer.nextToken().trim());
        return new Color(r, g, b);
    }

    private static enum HeaderFormat {
        LABEL("label"),
        DESCRIPTION("description"),
        BOTH("both"),
        NONE("none");

        private final String value;

        private HeaderFormat(String value) {
            this.value = value;
        }

        @NotNull
        public static HeaderFormat of(@NotNull String value) {
            for (HeaderFormat format : HeaderFormat.values()) {
                if (!format.value.equals(value)) continue;
                return format;
            }
            return LABEL;
        }

        public boolean hasLabel() {
            return this == LABEL || this == BOTH;
        }

        public boolean hasDescription() {
            return this == DESCRIPTION || this == BOTH;
        }
    }

    private static enum AppendStrategy {
        CREATE_NEW_SHEETS("create new sheets"),
        USE_EXISTING_SHEETS("use existing sheets");

        private final String value;

        private AppendStrategy(String value) {
            this.value = value;
        }

        @NotNull
        public static AppendStrategy of(@NotNull String value) {
            for (AppendStrategy strategy : AppendStrategy.values()) {
                if (!strategy.value.equals(value)) continue;
                return strategy;
            }
            return CREATE_NEW_SHEETS;
        }
    }

    static enum FontStyleProp {
        NONE,
        BOLD,
        ITALIC,
        STRIKEOUT,
        UNDERLINE;

    }
}

