/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDInsertReplaceMethod;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;

public class MySQLInsertReplaceMethodUpdate
implements DBDInsertReplaceMethod {
    @NotNull
    public String getOpeningClause(@NotNull DBSTable table, @NotNull DBRProgressMonitor monitor) {
        return "INSERT INTO";
    }

    public String getTrailingClause(@NotNull DBSTable table, @NotNull DBRProgressMonitor monitor, DBSAttributeBase[] attributes) {
        StringBuilder query = new StringBuilder();
        query.append(" ON DUPLICATE KEY UPDATE ");
        this.appendUpdateCase(query, table, attributes);
        return query.toString();
    }

    private void appendUpdateCase(@NotNull StringBuilder query, @NotNull DBSTable table, DBSAttributeBase[] attributes) {
        StringJoiner names = new StringJoiner(",");
        for (DBSAttributeBase attribute : attributes) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)attribute)) continue;
            String attrName = this.getAttributeName(table, attribute);
            names.add(attrName + "=VALUES(" + attrName + ")");
        }
        query.append(names);
    }

    private String getAttributeName(@NotNull DBSTable table, @NotNull DBSAttributeBase attribute) {
        return DBUtils.isPseudoAttribute((DBSAttributeBase)attribute) ? attribute.getName() : DBUtils.getObjectFullName((DBPDataSource)table.getDataSource(), (DBPNamedObject)attribute, (DBPEvaluationContext)DBPEvaluationContext.DML);
    }
}

