/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericForeignKeyManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.sqlite.SQLiteUtils;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTable;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.AbstractObjectManager;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;

public class SQLiteTableForeignKeyManager
extends GenericForeignKeyManager {
    public boolean canCreateObject(@NotNull Object container) {
        return true;
    }

    public boolean canEditObject(@NotNull GenericTableForeignKey object) {
        return true;
    }

    public boolean canDeleteObject(@NotNull GenericTableForeignKey object) {
        return true;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        throw new DBException("Forein key creation needs table recreation");
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        throw new DBException("Forein key modification needs table recreation");
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        throw new DBException("Forein key deletion needs table recreation");
    }

    public void deleteObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableForeignKey object, @NotNull Map<String, Object> options) throws DBException {
        SQLiteTable table;
        SQLObjectEditor.ObjectDeleteCommand deleteCommand = new SQLObjectEditor.ObjectDeleteCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_delete_object);
        commandContext.addCommand((DBECommand)deleteCommand, (DBECommandReflector)new AbstractObjectManager.DeleteObjectReflector((DBEObjectMaker)this), true);
        DBSTable dBSTable = object.getTable();
        if (dBSTable instanceof SQLiteTable && (table = (SQLiteTable)dBSTable).isPersisted()) {
            SQLiteUtils.makeRecreateTableCommand(commandContext, table, (DBECommand)deleteCommand);
        }
    }

    protected void createObjectReferences(DBRProgressMonitor monitor, DBECommandContext commandContext, SQLObjectEditor.ObjectCreateCommand createCommand) throws DBException {
        SQLiteTable table;
        DBSTable dBSTable = ((GenericTableForeignKey)createCommand.getObject()).getTable();
        if (dBSTable instanceof SQLiteTable && (table = (SQLiteTable)dBSTable).isPersisted()) {
            SQLiteUtils.makeRecreateTableCommand(commandContext, table, (DBECommand)createCommand);
        }
    }
}

