/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.h2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.utils.CommonUtils;

public class H2Sequence
extends GenericSequence {
    private long startValue;
    private long cache;
    private boolean isCycle;
    private String dataType;
    private String description;

    H2Sequence(GenericStructContainer container, String name, String description, Number lastValue, Number minValue, Number maxValue, Number incrementBy, @NotNull JDBCResultSet dbResult) {
        super(container, name, description, lastValue, minValue, maxValue, incrementBy);
        this.description = description;
        if (this.getDataSource().isServerVersionAtLeast(2, 0)) {
            this.startValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"START_VALUE");
            this.cache = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CACHE");
            this.isCycle = CommonUtils.getBoolean((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CYCLE_OPTION"), (boolean)false);
            this.dataType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_TYPE");
        }
    }

    @Property(viewable=true, order=5, visibleIf=H2SequenceFieldsValueValidator.class)
    public long getStartValue() {
        return this.startValue;
    }

    @Property(viewable=true, order=6, visibleIf=H2SequenceFieldsValueValidator.class)
    public long getCache() {
        return this.cache;
    }

    @Property(viewable=true, order=7, visibleIf=H2SequenceFieldsValueValidator.class)
    public boolean isCycle() {
        return this.isCycle;
    }

    @Property(viewable=true, order=8, visibleIf=H2SequenceFieldsValueValidator.class)
    public String getDataType() {
        return this.dataType;
    }

    @Property(viewable=true, editable=true, updatable=true, order=5, length=PropertyLength.MULTILINE)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class H2SequenceFieldsValueValidator
    implements IPropertyValueValidator<H2Sequence, Object> {
        public boolean isValidValue(@NotNull H2Sequence object, @Nullable Object value) throws IllegalArgumentException {
            return object.getDataSource().isServerVersionAtLeast(2, 0);
        }
    }
}

