/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.ui.config;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2PlanConfig;
import org.jkiss.dbeaver.ext.db2.ui.editors.DB2TablespaceChooser;
import org.jkiss.dbeaver.ext.db2.ui.internal.DB2Messages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;

public class DB2PlanSchemaConfigurator
implements DBEObjectConfigurator<DB2PlanConfig> {
    protected static final Log log = Log.getLog(DB2PlanSchemaConfigurator.class);

    public DB2PlanConfig configureObject(final @NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object db2dataSource, final @NotNull DB2PlanConfig object, @NotNull Map<String, Object> options) {
        DB2DataSource db2source = (DB2DataSource)db2dataSource;
        try {
            final JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)db2source, (String)"Read EXPLAIN tables");
            return (DB2PlanConfig)new UITask<DB2PlanConfig>(this){

                protected DB2PlanConfig runTask() {
                    String msg = String.format(DB2Messages.dialog_explain_ask_to_create, object.getSessionUserSchema());
                    if (!UIUtils.confirmAction((String)DB2Messages.dialog_explain_no_tables, (String)msg)) {
                        return null;
                    }
                    DB2TablespaceChooser tsChooserDialog = null;
                    try {
                        List listTablespaces = DB2Utils.getListOfUsableTsForExplain((DBRProgressMonitor)monitor, (JDBCSession)session);
                        if (listTablespaces.isEmpty()) {
                            DBWorkbench.getPlatformUI().showError(DB2Messages.dialog_explain_no_tablespace_found_title, DB2Messages.dialog_explain_no_tablespace_found);
                            return null;
                        }
                        tsChooserDialog = new DB2TablespaceChooser(UIUtils.getActiveWorkbenchShell(), listTablespaces);
                    }
                    catch (SQLException e) {
                        log.error((Object)e);
                    }
                    if (tsChooserDialog != null && tsChooserDialog.open() == 0) {
                        object.setTablespace(tsChooserDialog.getSelectedTablespace());
                        return object;
                    }
                    return null;
                }
            }.execute();
        }
        catch (DBCException e) {
            log.error((Object)"Error reading EXPLAIN tables", (Throwable)e);
            return object;
        }
    }
}

