/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdProcedure;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdSQLDialect;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTable;
import org.jkiss.dbeaver.ext.firebird.model.plan.FireBirdPlanAnalyser;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.IntKeyMap;

public class FireBirdDataSource
extends GenericDataSource
implements DBCQueryPlanner {
    private static final Log log = Log.getLog(FireBirdDataSource.class);
    private Map<String, IntKeyMap<MetaFieldInfo>> metaFields = new HashMap<String, IntKeyMap<MetaFieldInfo>>();

    public FireBirdDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new FireBirdSQLDialect());
    }

    public String getMetaFieldValue(String name, int type) {
        MetaFieldInfo info;
        IntKeyMap<MetaFieldInfo> fieldMap = this.metaFields.get(name);
        if (fieldMap != null && (info = (MetaFieldInfo)fieldMap.get(type)) != null) {
            return info.name;
        }
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read generic metadata");
             JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM RDB$TYPES");){
            monitor.subTask("Load Firebird types");
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String fieldName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$FIELD_NAME");
                    if (fieldName == null) continue;
                    fieldName = fieldName.trim();
                    int fieldType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$TYPE");
                    String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$TYPE_NAME");
                    if (typeName == null) continue;
                    typeName = typeName.trim();
                    String fieldDescription = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$SYSTEM_FLAG");
                    IntKeyMap metaFields = this.metaFields.get(fieldName);
                    if (metaFields == null) {
                        metaFields = new IntKeyMap();
                        this.metaFields.put(fieldName, (IntKeyMap<MetaFieldInfo>)metaFields);
                    }
                    metaFields.put(fieldType, (Object)new MetaFieldInfo(fieldType, typeName, fieldDescription));
                }
            }
        }
        catch (SQLException ex) {
            log.error((Object)"Error reading FB metadata", (Throwable)ex);
        }
        super.initialize(monitor);
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBException {
        FireBirdPlanAnalyser plan = new FireBirdPlanAnalyser(this, (JDBCSession)session, query);
        plan.explain();
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    public List<FireBirdTable> getPhysicalTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getPhysicalTables(monitor);
    }

    public List<FireBirdTable> getTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getTables(monitor);
    }

    public List<FireBirdProcedure> getProcedures(@NotNull DBRProgressMonitor monitor) throws DBException {
        return (List)super.getProcedures(monitor);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return FireBirdTable.class;
    }

    private static class MetaFieldInfo {
        int type;
        String name;
        String description;

        MetaFieldInfo(int type, String name, String description) {
            this.type = type;
            this.name = name;
            this.description = description;
        }

        public String toString() {
            return this.name + ":" + this.type;
        }
    }
}

