﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/discovery/ApplicationDiscoveryService_EXPORTS.h>
#include <aws/discovery/model/DeleteAgentErrorCode.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ApplicationDiscoveryService {
namespace Model {

/**
 * <p> An object representing the agent or data collector that failed to delete,
 * each containing agentId, errorMessage, and errorCode. </p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/BatchDeleteAgentError">AWS
 * API Reference</a></p>
 */
class BatchDeleteAgentError {
 public:
  AWS_APPLICATIONDISCOVERYSERVICE_API BatchDeleteAgentError() = default;
  AWS_APPLICATIONDISCOVERYSERVICE_API BatchDeleteAgentError(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPLICATIONDISCOVERYSERVICE_API BatchDeleteAgentError& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPLICATIONDISCOVERYSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The ID of the agent or data collector to delete. </p>
   */
  inline const Aws::String& GetAgentId() const { return m_agentId; }
  inline bool AgentIdHasBeenSet() const { return m_agentIdHasBeenSet; }
  template <typename AgentIdT = Aws::String>
  void SetAgentId(AgentIdT&& value) {
    m_agentIdHasBeenSet = true;
    m_agentId = std::forward<AgentIdT>(value);
  }
  template <typename AgentIdT = Aws::String>
  BatchDeleteAgentError& WithAgentId(AgentIdT&& value) {
    SetAgentId(std::forward<AgentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The description of the error that occurred for the delete failed agent. </p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  BatchDeleteAgentError& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The type of error that occurred for the delete failed agent. Valid status
   * are: AGENT_IN_USE | NOT_FOUND | INTERNAL_SERVER_ERROR. </p>
   */
  inline DeleteAgentErrorCode GetErrorCode() const { return m_errorCode; }
  inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }
  inline void SetErrorCode(DeleteAgentErrorCode value) {
    m_errorCodeHasBeenSet = true;
    m_errorCode = value;
  }
  inline BatchDeleteAgentError& WithErrorCode(DeleteAgentErrorCode value) {
    SetErrorCode(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_agentId;

  Aws::String m_errorMessage;

  DeleteAgentErrorCode m_errorCode{DeleteAgentErrorCode::NOT_SET};
  bool m_agentIdHasBeenSet = false;
  bool m_errorMessageHasBeenSet = false;
  bool m_errorCodeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationDiscoveryService
}  // namespace Aws
