/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/**
 * Representing a Server configuration.
 */
#ifndef QtOAI_SERVERVCONFIGURATION_H
#define QtOAI_SERVERVCONFIGURATION_H

#include "QtOAIServerVariable.h"

#include <QtCore/qstring.h>
#include <QtCore/qmap.h>
#include <QtCore/qurl.h>

namespace QtCommonOpenAPI {

class QtOAIServerConfiguration {
public:
    /**
     * @param urlTemplate A URL template to the target host.
     * @param description A description of the host designated by the URL.
     * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
     */
    QtOAIServerConfiguration(const QString &urlTemplate, const QString &description, const QMap<QString, QtOAIServerVariable> &variables)
    : m_description(description),
      m_variables(variables),
      m_urlTemplate(urlTemplate) {}
    QtOAIServerConfiguration() {}
    ~QtOAIServerConfiguration() {}

    /**
    * Original URL template
    *
    * @return Original URL template.
    */
    QString urlTemplate() const { return m_urlTemplate; }

    /**
     * Format URL template using server's variables.
     *
     * @return URL, where the server variables are substituted with actual values.
     */
    QUrl url() const {
        if (m_variables.empty())
            return QUrl(m_urlTemplate); // nothing to substitute

        QString url = m_urlTemplate;
        // go through variables and replace placeholders
        for (const auto &[name, serverVariable] : m_variables.asKeyValueRange()) {
            const QString value = serverVariable.m_defaultValue;
            if (!serverVariable.m_enumValues.empty() && !serverVariable.m_enumValues.contains(value)) {
                qWarning("The variable %s in the server URL has an invalid value %s.",
                          qPrintable(name), qPrintable(value));
            }
            const QString varTemplate = u'{' + name + u'}';
            url = url.replace(varTemplate, value);
        }
        return QUrl(url);
    }

    QtOAIServerVariable::ServerError setDefaultValue(const QString &variable, const QString &value) {
      if (m_variables.contains(variable))
        return m_variables[variable].setDefaultValue(value);
      return QtOAIServerVariable::ServerError::ServerVariableNotFound;
    }

    QString m_description;
    QMap<QString, QtOAIServerVariable> m_variables;
    QString m_urlTemplate;
};

} // namespace QtCommonOpenAPI

#endif // QtOAI_SERVERVCONFIGURATION_H
