/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.jvm;

import com.jetbrains.fus.reporting.FileHandle;
import com.jetbrains.fus.reporting.FileStorage;
import com.jetbrains.fus.reporting.FileStorageMode;
import com.jetbrains.fus.reporting.jvm.InMemoryFileHandle;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/fus/reporting/jvm/InMemoryJvmFileStorage;", "Lcom/jetbrains/fus/reporting/FileStorage;", "()V", "files", "", "", "", "exists", "", "path", "openFileHandle", "Lcom/jetbrains/fus/reporting/FileHandle;", "mode", "Lcom/jetbrains/fus/reporting/FileStorageMode;", "read", "write", "", "content", "api-jvm-defaults"})
public final class InMemoryJvmFileStorage
implements FileStorage {
    @NotNull
    private final Map<String, byte[]> files = new LinkedHashMap();

    @Override
    @NotNull
    public FileHandle openFileHandle(@NotNull String path, @NotNull FileStorageMode mode) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return new InMemoryFileHandle(path, mode, this.files);
    }

    @Override
    @Nullable
    public byte[] read(@NotNull String path) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] byArray2 = this.files.get(path);
        if (byArray2 != null) {
            byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length);
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
        } else {
            byArray = null;
        }
        return byArray;
    }

    @Override
    public void write(@NotNull String path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        byte[] byArray = Arrays.copyOf(content, content.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        this.files.put(path, byArray);
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.files.containsKey(path);
    }
}

