/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.PairProcessor;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;

final class ObjectObjectTransientMultiMaplet<K, V extends Streamable>
extends ObjectObjectMultiMaplet<K, V> {
    private final Object2ObjectOpenCustomHashMap<K, Collection<V>> myMap;
    private final Supplier<? extends Collection<V>> myCollectionFactory;

    ObjectObjectTransientMultiMaplet(Hash.Strategy<K> hashingStrategy, Supplier<? extends Collection<V>> collectionFactory) {
        this.myMap = new Object2ObjectOpenCustomHashMap(hashingStrategy);
        this.myCollectionFactory = collectionFactory;
    }

    @Override
    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public Collection<V> get(K key) {
        return (Collection)this.myMap.get(key);
    }

    @Override
    public void putAll(ObjectObjectMultiMaplet<K, V> m) {
        m.forEachEntry((key, value) -> {
            this.put((K)key, (V)value);
            return true;
        });
    }

    @Override
    public void put(K key, Collection<V> value) {
        Collection x = (Collection)this.myMap.get(key);
        if (x == null) {
            this.myMap.put(key, value);
        } else {
            x.addAll(value);
        }
    }

    @Override
    public void replace(K key, Collection<V> value) {
        if (value == null || value.isEmpty()) {
            this.myMap.remove(key);
        } else {
            this.myMap.put(key, value);
        }
    }

    @Override
    public void put(K key, V value) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection == null) {
            Collection<V> x = this.myCollectionFactory.get();
            x.add(value);
            this.myMap.put(key, x);
        } else {
            collection.add(value);
        }
    }

    @Override
    public void removeFrom(K key, V value) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection != null && collection.remove(value) && collection.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    @Override
    public void removeAll(K key, Collection<V> values) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection != null && collection.removeAll(values) && collection.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    @Override
    public void remove(K key) {
        this.myMap.remove(key);
    }

    @Override
    public void replaceAll(ObjectObjectMultiMaplet<K, V> m) {
        m.forEachEntry((key, value) -> {
            this.replace((K)key, (Collection<V>)value);
            return true;
        });
    }

    @Override
    public void forEachEntry(@NotNull PairProcessor<? super K, ? super Collection<V>> procedure) {
        Map.Entry entry;
        if (procedure == null) {
            ObjectObjectTransientMultiMaplet.$$$reportNull$$$0(0);
        }
        ObjectIterator objectIterator = this.myMap.entrySet().iterator();
        while (objectIterator.hasNext() && procedure.process((entry = (Map.Entry)objectIterator.next()).getKey(), entry.getValue())) {
        }
    }

    @Override
    public void close() {
        this.myMap.clear();
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "org/jetbrains/jps/builders/java/dependencyView/ObjectObjectTransientMultiMaplet", "forEachEntry"));
    }
}

