/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class CreditCardValidator
implements IValidator<String> {
    private static final long serialVersionUID = 1L;
    private CreditCard cardId = CreditCard.INVALID;
    private boolean failOnUnknown = true;

    public CreditCardValidator() {
    }

    public CreditCardValidator(boolean failOnUnkown) {
        this.failOnUnknown = failOnUnkown;
    }

    public final CreditCard getCardId() {
        return this.cardId;
    }

    protected void setCardId(CreditCard cardId) {
        this.cardId = cardId;
    }

    @Override
    public void validate(IValidatable<String> validatable) {
        String value = validatable.getValue();
        try {
            if (!this.isLengthAndPrefixCorrect(value)) {
                validatable.error(this.decorate(new ValidationError(this), validatable));
            }
        }
        catch (NumberFormatException ex) {
            validatable.error(this.decorate(new ValidationError(this), validatable));
        }
    }

    protected IValidationError decorate(IValidationError error, IValidatable<String> validatable) {
        return error;
    }

    protected boolean isLengthAndPrefixCorrect(String creditCardNumber) {
        if (creditCardNumber == null) {
            return false;
        }
        return (creditCardNumber = creditCardNumber.replaceAll("[ -]", "")).length() >= 12 && creditCardNumber.length() <= 19 && this.isChecksumCorrect(creditCardNumber) && (!this.failOnUnknown || this.determineCardId(creditCardNumber) != CreditCard.INVALID);
    }

    public final CreditCard determineCardId(String creditCardNumber) {
        if (creditCardNumber == null) {
            return CreditCard.INVALID;
        }
        if ((creditCardNumber = creditCardNumber.replaceAll("[ -]", "")).length() >= 12 && creditCardNumber.length() <= 19 && this.isChecksumCorrect(creditCardNumber)) {
            this.cardId = CreditCard.INVALID;
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isAmericanExpress(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isChinaUnionPay(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isDinersClubCarteBlanche(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isDinersClubInternational(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isDinersClubUsAndCanada(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isDiscoverCard(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isJCB(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isLaser(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isMaestro(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isMastercard(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isSolo(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isSwitch(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isVisa(creditCardNumber);
            }
            if (this.cardId == CreditCard.INVALID) {
                this.cardId = this.isVisaElectron(creditCardNumber);
            }
        } else {
            this.cardId = this.isUnknown(creditCardNumber);
        }
        return this.cardId;
    }

    protected CreditCard isUnknown(String creditCardNumber) {
        return CreditCard.INVALID;
    }

    private CreditCard isAmericanExpress(String creditCardNumber) {
        if (creditCardNumber.length() == 15 && (creditCardNumber.startsWith("34") || creditCardNumber.startsWith("37"))) {
            return CreditCard.AMERICAN_EXPRESS;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isChinaUnionPay(String creditCardNumber) {
        int firstDigits;
        if (creditCardNumber.length() >= 16 && creditCardNumber.length() <= 19 && creditCardNumber.startsWith("622") && (firstDigits = Integer.parseInt(creditCardNumber.substring(0, 6))) >= 622126 && firstDigits <= 622925) {
            return CreditCard.CHINA_UNIONPAY;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isDinersClubCarteBlanche(String creditCardNumber) {
        int firstDigits;
        if (creditCardNumber.length() == 14 && creditCardNumber.startsWith("30") && (firstDigits = Integer.parseInt(creditCardNumber.substring(0, 3))) >= 300 && firstDigits <= 305) {
            return CreditCard.DINERS_CLUB_CARTE_BLANCHE;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isDinersClubInternational(String creditCardNumber) {
        if (creditCardNumber.length() == 14 && creditCardNumber.startsWith("36")) {
            return CreditCard.DINERS_CLUB_INTERNATIONAL;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isDinersClubUsAndCanada(String creditCardNumber) {
        if (creditCardNumber.length() == 16 && (creditCardNumber.startsWith("54") || creditCardNumber.startsWith("55"))) {
            return CreditCard.DINERS_CLUB_US_AND_CANADA;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isDiscoverCard(String creditCardNumber) {
        if (creditCardNumber.length() == 16 && creditCardNumber.startsWith("6")) {
            int firstThreeDigits = Integer.parseInt(creditCardNumber.substring(0, 3));
            int firstSixDigits = Integer.parseInt(creditCardNumber.substring(0, 6));
            if (creditCardNumber.startsWith("6011") || creditCardNumber.startsWith("65") || firstThreeDigits >= 644 && firstThreeDigits <= 649 || firstSixDigits >= 622126 && firstSixDigits <= 622925) {
                return CreditCard.DISCOVER_CARD;
            }
        }
        return CreditCard.INVALID;
    }

    private CreditCard isJCB(String creditCardNumber) {
        int firstFourDigits;
        if (creditCardNumber.length() == 16 && (firstFourDigits = Integer.parseInt(creditCardNumber.substring(0, 4))) >= 3528 && firstFourDigits <= 3589) {
            return CreditCard.JCB;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isLaser(String creditCardNumber) {
        if (creditCardNumber.length() >= 16 && creditCardNumber.length() <= 19 && (creditCardNumber.startsWith("6304") || creditCardNumber.startsWith("6706") || creditCardNumber.startsWith("6771") || creditCardNumber.startsWith("6709"))) {
            return CreditCard.LASER;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isMaestro(String creditCardNumber) {
        if (creditCardNumber.length() >= 12 && creditCardNumber.length() <= 19 && (creditCardNumber.startsWith("5018") || creditCardNumber.startsWith("5020") || creditCardNumber.startsWith("5038") || creditCardNumber.startsWith("6304") || creditCardNumber.startsWith("6759") || creditCardNumber.startsWith("6761") || creditCardNumber.startsWith("6763"))) {
            return CreditCard.MAESTRO;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isSolo(String creditCardNumber) {
        if ((creditCardNumber.length() == 16 || creditCardNumber.length() == 18 || creditCardNumber.length() == 19) && (creditCardNumber.startsWith("6334") || creditCardNumber.startsWith("6767"))) {
            return CreditCard.SOLO;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isSwitch(String creditCardNumber) {
        if ((creditCardNumber.length() == 16 || creditCardNumber.length() == 18 || creditCardNumber.length() == 19) && (creditCardNumber.startsWith("4903") || creditCardNumber.startsWith("4905") || creditCardNumber.startsWith("4911") || creditCardNumber.startsWith("4936") || creditCardNumber.startsWith("564182") || creditCardNumber.startsWith("633110") || creditCardNumber.startsWith("6333") || creditCardNumber.startsWith("6759"))) {
            return CreditCard.SWITCH;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isVisa(String creditCardNumber) {
        if ((creditCardNumber.length() == 13 || creditCardNumber.length() == 16) && creditCardNumber.startsWith("4")) {
            return CreditCard.VISA;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isVisaElectron(String creditCardNumber) {
        if (creditCardNumber.length() == 16 && (creditCardNumber.startsWith("417500") || creditCardNumber.startsWith("4917") || creditCardNumber.startsWith("4913") || creditCardNumber.startsWith("4508") || creditCardNumber.startsWith("4844"))) {
            return CreditCard.VISA_ELECTRON;
        }
        return CreditCard.INVALID;
    }

    private CreditCard isMastercard(String creditCardNumber) {
        int firstTwoDigits;
        if (creditCardNumber.length() == 16 && (firstTwoDigits = Integer.parseInt(creditCardNumber.substring(0, 2))) >= 51 && firstTwoDigits <= 55) {
            return CreditCard.MASTERCARD;
        }
        return CreditCard.INVALID;
    }

    protected final boolean isChecksumCorrect(String creditCardNumber) {
        int nulOffset = 48;
        int sum = 0;
        for (int i = 1; i <= creditCardNumber.length(); ++i) {
            int currentDigit = creditCardNumber.charAt(creditCardNumber.length() - i) - nulOffset;
            if (i % 2 == 0) {
                currentDigit = (currentDigit *= 2) > 9 ? currentDigit - 9 : currentDigit;
                sum += currentDigit;
                continue;
            }
            sum += currentDigit;
        }
        return sum % 10 == 0;
    }

    public static enum CreditCard {
        INVALID(null),
        AMERICAN_EXPRESS("American Express"),
        CHINA_UNIONPAY("China UnionPay"),
        DINERS_CLUB_CARTE_BLANCHE("Diners Club Carte Blanche"),
        DINERS_CLUB_INTERNATIONAL("Diners Club International"),
        DINERS_CLUB_US_AND_CANADA("Diners Club US & Canada"),
        DISCOVER_CARD("Discover Card"),
        JCB("JCB"),
        LASER("Laser"),
        MAESTRO("Maestro"),
        MASTERCARD("MasterCard"),
        SOLO("Solo"),
        SWITCH("Switch"),
        VISA("Visa"),
        VISA_ELECTRON("Visa Electron");

        private final String name;

        private CreditCard(String name) {
            this.name = name;
        }
    }
}

