/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.settings.DebugSettings;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;

public class CheckBoxMultipleChoice<T>
extends ListMultipleChoice<T> {
    private static final long serialVersionUID = 1L;
    private String prefix = "";
    private String suffix = "";
    private AbstractChoice.LabelPosition labelPosition = AbstractChoice.LabelPosition.AFTER;

    public CheckBoxMultipleChoice(String id) {
        super(id);
    }

    public CheckBoxMultipleChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public CheckBoxMultipleChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends Collection<T>> model, List<? extends T> choices) {
        super(id, model, choices);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends Collection<T>> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends Collection<T>> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends Collection<T>> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected String getPrefix(int index, T choice) {
        return this.getPrefix();
    }

    protected String getSuffix(int index, T choice) {
        return this.getSuffix();
    }

    public final CheckBoxMultipleChoice<T> setPrefix(String prefix) {
        Page page = this.findPage();
        if (page != null) {
            this.addStateChange();
        }
        this.prefix = prefix;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public final CheckBoxMultipleChoice<T> setSuffix(String suffix) {
        Page page = this.findPage();
        if (page != null) {
            this.addStateChange();
        }
        this.suffix = suffix;
        return this;
    }

    public CheckBoxMultipleChoice<T> setLabelPosition(AbstractChoice.LabelPosition labelPosition) {
        Args.notNull((Object)((Object)labelPosition), (String)"labelPosition");
        this.labelPosition = labelPosition;
        return this;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("multiple");
        tag.remove("size");
        tag.remove("disabled");
        tag.remove("name");
    }

    @Override
    public final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        List choices = this.getChoices();
        AppendingStringBuffer buffer = new AppendingStringBuffer(70 * (choices.size() + 1));
        String selected = this.getValue();
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            this.appendOptionHtml(buffer, (T)choice, index, selected);
        }
        this.replaceComponentTagBody(markupStream, openTag, (CharSequence)buffer);
    }

    @Override
    protected void appendOptionHtml(AppendingStringBuffer buffer, T choice, int index, String selected) {
        Object displayValue = this.getChoiceRenderer().getDisplayValue(choice);
        Class<?> objectClass = displayValue == null ? null : displayValue.getClass();
        String label = "";
        if (objectClass != null && objectClass != String.class) {
            IConverter<?> converter = this.getConverter(objectClass);
            label = converter.convertToString(displayValue, this.getLocale());
        } else if (displayValue != null) {
            label = displayValue.toString();
        }
        if (label != null) {
            DebugSettings debugSettings;
            String componentPathAttributeName;
            buffer.append(this.getPrefix(index, choice));
            String id = this.getChoiceRenderer().getIdValue(choice, index);
            String idAttr = this.getCheckBoxMarkupId(id);
            String display = label;
            if (this.localizeDisplayValues()) {
                display = this.getLocalizer().getString(label, (Component)this, label);
            }
            CharSequence escaped = this.getEscapeModelStrings() ? Strings.escapeMarkup((CharSequence)display) : display;
            IValueMap labelAttrs = this.getAdditionalAttributesForLabel(index, choice);
            StringBuilder extraLabelAttributes = new StringBuilder();
            if (labelAttrs != null) {
                for (Object attr : labelAttrs.entrySet()) {
                    extraLabelAttributes.append(' ').append(Strings.escapeMarkup((CharSequence)((CharSequence)attr.getKey()))).append("=\"").append(Strings.escapeMarkup((CharSequence)attr.getValue().toString())).append('\"');
                }
            }
            switch (this.labelPosition) {
                case BEFORE: {
                    buffer.append("<label for=\"").append((Object)Strings.escapeMarkup((CharSequence)idAttr)).append('\"').append(extraLabelAttributes).append('>').append((Object)escaped).append("</label>");
                    break;
                }
                case WRAP_BEFORE: {
                    buffer.append("<label").append(extraLabelAttributes).append('>').append((Object)escaped).append(' ');
                    break;
                }
                case WRAP_AFTER: {
                    buffer.append("<label").append(extraLabelAttributes).append('>');
                }
            }
            buffer.append("<input name=\"");
            buffer.append(this.getInputName());
            buffer.append('\"');
            buffer.append(" type=\"checkbox\"");
            if (this.isSelected(choice, index, selected)) {
                buffer.append(" checked=\"checked\"");
            }
            if (this.isDisabled(choice, index, selected) || !this.isEnabledInHierarchy()) {
                buffer.append(" disabled=\"disabled\"");
            }
            buffer.append(" value=\"");
            buffer.append((Object)Strings.escapeMarkup((CharSequence)id));
            buffer.append("\" id=\"");
            buffer.append((Object)Strings.escapeMarkup((CharSequence)idAttr));
            buffer.append('\"');
            IValueMap attrs = this.getAdditionalAttributes(index, choice);
            if (attrs != null) {
                for (Map.Entry attr : attrs.entrySet()) {
                    buffer.append(' ').append((Object)Strings.escapeMarkup((CharSequence)((CharSequence)attr.getKey()))).append("=\"").append((Object)Strings.escapeMarkup((CharSequence)attr.getValue().toString())).append('\"');
                }
            }
            if (!Strings.isEmpty((CharSequence)(componentPathAttributeName = (debugSettings = this.getApplication().getDebugSettings()).getComponentPathAttributeName()))) {
                CharSequence path = this.getPageRelativePath();
                path = Strings.replaceAll((CharSequence)path, (CharSequence)"_", (CharSequence)"__");
                path = Strings.replaceAll((CharSequence)path, (CharSequence)":", (CharSequence)"_");
                buffer.append(' ').append(componentPathAttributeName).append("=\"").append((Object)path).append("_input_").append(index).append('\"');
            }
            buffer.append("/>");
            switch (this.labelPosition) {
                case WRAP_BEFORE: {
                    buffer.append("</label>");
                    break;
                }
                case WRAP_AFTER: {
                    buffer.append(' ').append((Object)escaped).append("</label>");
                    break;
                }
                case AFTER: {
                    buffer.append("<label for=\"").append((Object)Strings.escapeMarkup((CharSequence)idAttr)).append('\"').append(extraLabelAttributes).append('>').append((Object)escaped).append("</label>");
                }
            }
            buffer.append(this.getSuffix(index, choice));
        }
    }

    protected IValueMap getAdditionalAttributesForLabel(int index, T choice) {
        return null;
    }

    protected IValueMap getAdditionalAttributes(int index, T choice) {
        return null;
    }

    protected String getCheckBoxMarkupId(String id) {
        return this.getMarkupId() + '-' + this.getInputName() + '_' + id;
    }
}

