/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.resource.FileSystemPathService;

public class FileSystemJarPathService
implements FileSystemPathService {
    public static final MetaDataKey<Map<String, FileSystem>> FILE_SYSTEM_META_DATA_KEY = new MetaDataKey<Map<String, FileSystem>>(){
        private static final long serialVersionUID = 1L;
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path getPath(URI uri, Map<String, String> env) {
        try {
            String uriString = uri.toString();
            int indexOfExclamationMark = uriString.indexOf(33);
            String jarFile = uriString.substring(0, indexOfExclamationMark);
            FileSystem fileSystem = null;
            MetaDataKey<Map<String, FileSystem>> metaDataKey = FILE_SYSTEM_META_DATA_KEY;
            synchronized (metaDataKey) {
                Map<String, FileSystem> metaData = Application.get().getMetaData(FILE_SYSTEM_META_DATA_KEY);
                if (metaData == null) {
                    metaData = new HashMap<String, FileSystem>();
                    Application.get().setMetaData(FILE_SYSTEM_META_DATA_KEY, metaData);
                }
                if ((fileSystem = metaData.get(jarFile)) == null) {
                    if (env == null) {
                        env = new HashMap<String, String>();
                        env.put("create", "true");
                        env.put("encoding", "UTF-8");
                    }
                    fileSystem = FileSystems.newFileSystem(new URI(jarFile), env);
                    metaData.put(jarFile, fileSystem);
                }
            }
            String fileName = uriString.substring(uriString.indexOf(33) + 1);
            return fileSystem.getPath(fileName, new String[0]);
        }
        catch (IOException | URISyntaxException e) {
            throw new WicketRuntimeException("Error while creating a jar file system", e);
        }
    }

    @Override
    public boolean isResponsible(URI uri) {
        return uri.getScheme().equals("jar") && uri.toString().indexOf(33) != -1;
    }
}

