/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.feedback;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.feedback.FeedbackCollector;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.panel.FeedbackPanel;

public class FencedFeedbackPanel
extends FeedbackPanel {
    private static final long serialVersionUID = 1L;
    private static final MetaDataKey<Integer> FENCE_KEY = new MetaDataKey<Integer>(){
        private static final long serialVersionUID = 1L;
    };
    private final Component fence;

    public FencedFeedbackPanel(String id) {
        this(id, (Component)null);
    }

    public FencedFeedbackPanel(String id, Component fence) {
        this(id, fence, null);
    }

    public FencedFeedbackPanel(String id, IFeedbackMessageFilter filter) {
        this(id, null, filter);
    }

    public FencedFeedbackPanel(String id, Component fence, IFeedbackMessageFilter filter) {
        super(id, filter);
        this.fence = fence;
        if (fence != null) {
            this.incrementFenceCount();
        }
    }

    private void incrementFenceCount() {
        Integer count = this.fence.getMetaData(FENCE_KEY);
        count = count == null ? 1 : count + 1;
        this.fence.setMetaData(FENCE_KEY, count);
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        if (this.fence != null) {
            this.decrementFenceCount();
        }
    }

    private void decrementFenceCount() {
        Integer count = this.fence.getMetaData(FENCE_KEY);
        count = count == null || count == 1 ? null : Integer.valueOf(count - 1);
        this.fence.setMetaData(FENCE_KEY, count);
    }

    @Override
    protected FeedbackMessagesModel newFeedbackMessagesModel() {
        return new FeedbackMessagesModel(this){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<FeedbackMessage> collectMessages(Component panel, IFeedbackMessageFilter filter) {
                if (FencedFeedbackPanel.this.fence == null) {
                    return new FencedFeedbackCollector(panel.getPage(), true).collect(filter);
                }
                return new FencedFeedbackCollector(FencedFeedbackPanel.this.fence, false).collect(filter);
            }
        };
    }

    @Override
    protected void onReAdd() {
        if (this.fence != null) {
            this.incrementFenceCount();
        }
        super.onReAdd();
    }

    private final class FencedFeedbackCollector
    extends FeedbackCollector {
        private FencedFeedbackCollector(Component component, boolean includeSession) {
            super(component, includeSession);
        }

        @Override
        protected boolean shouldRecurseInto(Component component) {
            return !this.componentIsMarkedAsFence(component);
        }

        private boolean componentIsMarkedAsFence(Component component) {
            return component.getMetaData(FENCE_KEY) != null;
        }
    }
}

