/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.client;

import org.apache.uniffle.common.netty.MessageEncoder;
import org.apache.uniffle.common.netty.client.TransportClient;
import org.apache.uniffle.common.netty.client.TransportClientFactory;
import org.apache.uniffle.common.netty.client.TransportConf;
import org.apache.uniffle.common.netty.handle.BaseMessageHandler;
import org.apache.uniffle.common.netty.handle.TransportChannelHandler;
import org.apache.uniffle.common.netty.handle.TransportRequestHandler;
import org.apache.uniffle.common.netty.handle.TransportResponseHandler;
import org.apache.uniffle.shaded.io.netty.channel.Channel;
import org.apache.uniffle.shaded.io.netty.channel.ChannelHandler;
import org.apache.uniffle.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.uniffle.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.uniffle.shaded.io.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportContext {
    private static final Logger logger = LoggerFactory.getLogger(TransportContext.class);
    private TransportConf transportConf;
    private final BaseMessageHandler msgHandler;
    private boolean closeIdleConnections;
    private static final MessageEncoder ENCODER = MessageEncoder.INSTANCE;

    public TransportContext(TransportConf transportConf) {
        this(transportConf, true);
    }

    public TransportContext(TransportConf transportConf, boolean closeIdleConnections) {
        this(transportConf, null, closeIdleConnections);
    }

    public TransportContext(TransportConf transportConf, BaseMessageHandler msgHandler, boolean closeIdleConnections) {
        this.transportConf = transportConf;
        this.msgHandler = msgHandler;
        this.closeIdleConnections = closeIdleConnections;
    }

    public TransportClientFactory createClientFactory() {
        return new TransportClientFactory(this);
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel, ChannelInboundHandlerAdapter decoder) {
        TransportChannelHandler channelHandler = this.createChannelHandler(channel, this.msgHandler);
        channel.pipeline().addLast("encoder", (ChannelHandler)ENCODER).addLast("decoder", (ChannelHandler)decoder).addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, this.transportConf.connectionTimeoutMs() / 1000)).addLast("responseHandler", (ChannelHandler)channelHandler);
        return channelHandler;
    }

    private TransportChannelHandler createChannelHandler(Channel channel, BaseMessageHandler msgHandler) {
        TransportResponseHandler responseHandler = new TransportResponseHandler(channel);
        TransportClient client = new TransportClient(channel, responseHandler);
        TransportRequestHandler requestHandler = new TransportRequestHandler(client, msgHandler);
        return new TransportChannelHandler(client, responseHandler, requestHandler, this.transportConf.connectionTimeoutMs(), this.closeIdleConnections);
    }

    public TransportConf getConf() {
        return this.transportConf;
    }
}

