/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.roaringbitmap;

import org.apache.uniffle.shaded.org.roaringbitmap.PeekableCharIterator;
import org.apache.uniffle.shaded.org.roaringbitmap.RunContainer;

class RunContainerCharIterator
implements PeekableCharIterator {
    int pos;
    int le = 0;
    int maxlength;
    int base;
    RunContainer parent;

    RunContainerCharIterator() {
    }

    RunContainerCharIterator(RunContainer p) {
        this.wrap(p);
    }

    @Override
    public PeekableCharIterator clone() {
        try {
            return (PeekableCharIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.nbrruns;
    }

    @Override
    public char next() {
        char ans = (char)(this.base + this.le);
        ++this.le;
        if (this.le > this.maxlength) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = this.parent.getLength(this.pos);
                this.base = this.parent.getValue(this.pos);
            }
        }
        return ans;
    }

    @Override
    public int nextAsInt() {
        int ans = this.base + this.le;
        ++this.le;
        if (this.le > this.maxlength) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = this.parent.getLength(this.pos);
                this.base = this.parent.getValue(this.pos);
            }
        }
        return ans;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    void wrap(RunContainer p) {
        this.parent = p;
        this.pos = 0;
        this.le = 0;
        if (this.pos < this.parent.nbrruns) {
            this.maxlength = this.parent.getLength(this.pos);
            this.base = this.parent.getValue(this.pos);
        }
    }

    @Override
    public void advanceIfNeeded(char minval) {
        while (this.base + this.maxlength < minval) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = this.parent.getLength(this.pos);
                this.base = this.parent.getValue(this.pos);
                continue;
            }
            return;
        }
        if (this.base > minval) {
            return;
        }
        this.le = minval - this.base;
    }

    @Override
    public char peekNext() {
        return (char)(this.base + this.le);
    }
}

