/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.storage.handler.impl.AbstractClientReadHandler;
import org.apache.uniffle.storage.handler.impl.HadoopShuffleReadHandler;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopClientReadHandler
extends AbstractClientReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopClientReadHandler.class);
    protected final int partitionNumPerRange;
    protected final int partitionNum;
    protected final int readBufferSize;
    private final String shuffleServerId;
    protected Roaring64NavigableMap expectBlockIds;
    protected Roaring64NavigableMap processBlockIds;
    protected final String storageBasePath;
    protected final Configuration hadoopConf;
    protected final List<HadoopShuffleReadHandler> readHandlers = Lists.newArrayList();
    private int readHandlerIndex;
    private ShuffleDataDistributionType distributionType;
    private Roaring64NavigableMap expectTaskIds;
    private boolean offHeapEnable = false;

    public HadoopClientReadHandler(String appId, int shuffleId, int partitionId, int indexReadLimit, int partitionNumPerRange, int partitionNum, int readBufferSize, Roaring64NavigableMap expectBlockIds, Roaring64NavigableMap processBlockIds, String storageBasePath, Configuration hadoopConf, ShuffleDataDistributionType distributionType, Roaring64NavigableMap expectTaskIds, String shuffleServerId, boolean offHeapEnable) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.partitionNumPerRange = partitionNumPerRange;
        this.partitionNum = partitionNum;
        this.readBufferSize = readBufferSize;
        this.expectBlockIds = expectBlockIds;
        this.processBlockIds = processBlockIds;
        this.storageBasePath = storageBasePath;
        this.hadoopConf = hadoopConf;
        this.readHandlerIndex = 0;
        this.distributionType = distributionType;
        this.expectTaskIds = expectTaskIds;
        this.shuffleServerId = shuffleServerId;
        this.offHeapEnable = offHeapEnable;
    }

    public HadoopClientReadHandler(String appId, int shuffleId, int partitionId, int indexReadLimit, int partitionNumPerRange, int partitionNum, int readBufferSize, Roaring64NavigableMap expectBlockIds, Roaring64NavigableMap processBlockIds, String storageBasePath, Configuration hadoopConf) {
        this(appId, shuffleId, partitionId, indexReadLimit, partitionNumPerRange, partitionNum, readBufferSize, expectBlockIds, processBlockIds, storageBasePath, hadoopConf, ShuffleDataDistributionType.NORMAL, Roaring64NavigableMap.bitmapOf((long[])new long[0]), null, false);
    }

    protected void init(String fullShufflePath) {
        FileSystem fs;
        Path baseFolder = new Path(fullShufflePath);
        try {
            fs = HadoopFilesystemProvider.getFilesystem((Path)baseFolder, (Configuration)this.hadoopConf);
        }
        catch (Exception ioe) {
            throw new RssException("Can't get FileSystem for " + baseFolder);
        }
        FileStatus[] indexFiles = null;
        try {
            indexFiles = fs.listStatus(baseFolder, file -> file.getName().endsWith(".index") && (this.shuffleServerId == null || file.getName().startsWith(this.shuffleServerId)));
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                LOG.info("Directory[" + baseFolder + "] not found. The data may not be flushed to this directory. Nothing will be read.");
            } else {
                String failedGetIndexFileMsg = "Can't list index file in  " + baseFolder;
                LOG.error(failedGetIndexFileMsg, (Throwable)e);
            }
            return;
        }
        if (indexFiles != null && indexFiles.length != 0) {
            for (FileStatus status : indexFiles) {
                LOG.info("Find index file for shuffleId[" + this.shuffleId + "], partitionId[" + this.partitionId + "] " + status.getPath());
                String filePrefix = this.getFileNamePrefix(status.getPath().toUri().toString());
                try {
                    HadoopShuffleReadHandler handler = new HadoopShuffleReadHandler(this.appId, this.shuffleId, this.partitionId, filePrefix, this.readBufferSize, this.expectBlockIds, this.processBlockIds, this.hadoopConf, this.distributionType, this.expectTaskIds, this.offHeapEnable);
                    this.readHandlers.add(handler);
                }
                catch (Exception e) {
                    LOG.warn("Can't create ShuffleReaderHandler for " + filePrefix, (Throwable)e);
                }
            }
            Collections.shuffle(this.readHandlers);
            LOG.info("Reading order of Hadoop files with name prefix: {}", this.readHandlers.stream().map(x -> x.filePrefix).collect(Collectors.toList()));
        }
    }

    @Override
    public ShuffleDataResult readShuffleData() {
        if (this.readHandlers.isEmpty()) {
            String fullShufflePath = ShuffleStorageUtils.getFullShuffleDataFolder(this.storageBasePath, ShuffleStorageUtils.getShuffleDataPathWithRange(this.appId, this.shuffleId, this.partitionId, this.partitionNumPerRange, this.partitionNum));
            this.init(fullShufflePath);
        }
        if (this.readHandlerIndex >= this.readHandlers.size()) {
            return new ShuffleDataResult();
        }
        HadoopShuffleReadHandler hadoopShuffleFileReader = this.readHandlers.get(this.readHandlerIndex);
        ShuffleDataResult shuffleDataResult = hadoopShuffleFileReader.readShuffleData();
        while (shuffleDataResult == null) {
            ++this.readHandlerIndex;
            if (this.readHandlerIndex >= this.readHandlers.size()) {
                return new ShuffleDataResult();
            }
            hadoopShuffleFileReader = this.readHandlers.get(this.readHandlerIndex);
            shuffleDataResult = hadoopShuffleFileReader.readShuffleData();
        }
        return shuffleDataResult;
    }

    protected String getFileNamePrefix(String fileName) {
        int point = fileName.lastIndexOf(".");
        return fileName.substring(0, point);
    }

    @Override
    public synchronized void close() {
        for (HadoopShuffleReadHandler handler : this.readHandlers) {
            handler.close();
        }
    }

    protected List<HadoopShuffleReadHandler> getHdfsShuffleFileReadHandlers() {
        return this.readHandlers;
    }

    protected int getReadHandlerIndex() {
        return this.readHandlerIndex;
    }
}

