/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.io.Writable;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.ShuffleAssignmentsInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleAssignmentsInfoWritable
implements Writable {
    private ShuffleAssignmentsInfo shuffleAssignmentsInfo;
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleAssignmentsInfoWritable.class);

    public ShuffleAssignmentsInfoWritable() {
    }

    public ShuffleAssignmentsInfoWritable(ShuffleAssignmentsInfo shuffleAssignmentsInfo) {
        this.shuffleAssignmentsInfo = shuffleAssignmentsInfo;
    }

    public void write(DataOutput dataOutput) throws IOException {
        if (this.shuffleAssignmentsInfo == null) {
            dataOutput.writeInt(-1);
            LOG.warn("shuffleAssignmentsInfo is null, no need write");
            return;
        }
        dataOutput.writeInt(1);
        Map<Integer, List<ShuffleServerInfo>> partitionToServers = this.shuffleAssignmentsInfo.getPartitionToServers();
        if (MapUtils.isEmpty(partitionToServers)) {
            dataOutput.writeInt(-1);
        } else {
            dataOutput.writeInt(partitionToServers.size());
            for (Map.Entry<Integer, List<ShuffleServerInfo>> entry : partitionToServers.entrySet()) {
                dataOutput.writeInt(entry.getKey());
                if (CollectionUtils.isEmpty((Collection)entry.getValue())) {
                    dataOutput.writeInt(-1);
                    continue;
                }
                dataOutput.writeInt(entry.getValue().size());
                for (ShuffleServerInfo serverInfo : entry.getValue()) {
                    dataOutput.writeUTF(serverInfo.getId());
                    dataOutput.writeUTF(serverInfo.getHost());
                    dataOutput.writeInt(serverInfo.getGrpcPort());
                }
            }
        }
        Map<ShuffleServerInfo, List<PartitionRange>> serverToPartitionRanges = this.shuffleAssignmentsInfo.getServerToPartitionRanges();
        if (MapUtils.isEmpty(serverToPartitionRanges)) {
            dataOutput.writeInt(-1);
        } else {
            dataOutput.writeInt(serverToPartitionRanges.size());
            for (Map.Entry<ShuffleServerInfo, List<PartitionRange>> entry : serverToPartitionRanges.entrySet()) {
                dataOutput.writeUTF(entry.getKey().getId());
                dataOutput.writeUTF(entry.getKey().getHost());
                dataOutput.writeInt(entry.getKey().getGrpcPort());
                if (CollectionUtils.isEmpty((Collection)entry.getValue())) {
                    dataOutput.writeInt(-1);
                    continue;
                }
                dataOutput.writeInt(entry.getValue().size());
                for (PartitionRange range : entry.getValue()) {
                    dataOutput.writeInt(range.getStart());
                    dataOutput.writeInt(range.getEnd());
                }
            }
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        int port;
        String host;
        String id;
        if (dataInput.readInt() == -1) {
            LOG.warn("shuffleAssignmentsInfo is null, no need read");
            return;
        }
        HashMap<Integer, List<ShuffleServerInfo>> partitionToServers = new HashMap<Integer, List<ShuffleServerInfo>>();
        int partitionToServersSize = dataInput.readInt();
        if (partitionToServersSize != -1) {
            for (int i = 0; i < partitionToServersSize; ++i) {
                Integer partitionId = dataInput.readInt();
                ArrayList<ShuffleServerInfo> shuffleServerInfoList = new ArrayList<ShuffleServerInfo>();
                int shuffleServerInfoListSize = dataInput.readInt();
                if (shuffleServerInfoListSize != -1) {
                    for (int i1 = 0; i1 < shuffleServerInfoListSize; ++i1) {
                        id = dataInput.readUTF();
                        host = dataInput.readUTF();
                        port = dataInput.readInt();
                        ShuffleServerInfo shuffleServerInfo = new ShuffleServerInfo(id, host, port);
                        shuffleServerInfoList.add(shuffleServerInfo);
                    }
                }
                partitionToServers.put(partitionId, shuffleServerInfoList);
            }
        }
        HashMap<ShuffleServerInfo, List<PartitionRange>> serverToPartitionRanges = new HashMap<ShuffleServerInfo, List<PartitionRange>>();
        int serverToPartitionRangesSize = dataInput.readInt();
        if (serverToPartitionRangesSize != -1) {
            for (int i = 0; i < serverToPartitionRangesSize; ++i) {
                ArrayList<PartitionRange> partitionRangeList = new ArrayList<PartitionRange>();
                id = dataInput.readUTF();
                host = dataInput.readUTF();
                port = dataInput.readInt();
                ShuffleServerInfo shuffleServerInfo = new ShuffleServerInfo(id, host, port);
                int partitionRangeListSize = dataInput.readInt();
                if (partitionRangeListSize != -1) {
                    for (int i1 = 0; i1 < partitionRangeListSize; ++i1) {
                        int start = dataInput.readInt();
                        int end = dataInput.readInt();
                        PartitionRange partitionRange = new PartitionRange(start, end);
                        partitionRangeList.add(partitionRange);
                    }
                }
                serverToPartitionRanges.put(shuffleServerInfo, partitionRangeList);
            }
        }
        this.shuffleAssignmentsInfo = new ShuffleAssignmentsInfo(partitionToServers, serverToPartitionRanges);
    }

    public ShuffleAssignmentsInfo getShuffleAssignmentsInfo() {
        return this.shuffleAssignmentsInfo;
    }
}

