/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.guava.collect;

import java.util.Queue;
import javax.annotation.CheckForNull;
import org.apache.uniffle.guava.annotations.GwtCompatible;
import org.apache.uniffle.guava.base.Preconditions;
import org.apache.uniffle.guava.collect.AbstractIterator;
import org.apache.uniffle.guava.collect.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

