/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.strategy.assignment;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.coordinator.ClusterManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.strategy.assignment.AbstractAssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.assignment.PartitionRangeAssignment;
import org.apache.uniffle.guava.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAssignmentStrategy
extends AbstractAssignmentStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAssignmentStrategy.class);
    private ClusterManager clusterManager;

    public BasicAssignmentStrategy(ClusterManager clusterManager, CoordinatorConf conf) {
        super(conf);
        this.clusterManager = clusterManager;
    }

    @Override
    public PartitionRangeAssignment assign(int totalPartitionNum, int partitionNumPerRange, int replica, Set<String> requiredTags, int requiredShuffleServerNumber, int estimateTaskConcurrency) {
        return this.assign(totalPartitionNum, partitionNumPerRange, replica, requiredTags, requiredShuffleServerNumber, estimateTaskConcurrency, Sets.newConcurrentHashSet());
    }

    @Override
    public PartitionRangeAssignment assign(int totalPartitionNum, int partitionNumPerRange, int replica, Set<String> requiredTags, int requiredShuffleServerNumber, int estimateTaskConcurrency, Set<String> faultyServerIds) {
        List<ServerNode> servers;
        int shuffleNodesMax;
        int expectedShuffleNodesNum = shuffleNodesMax = this.clusterManager.getShuffleNodesMax();
        if (requiredShuffleServerNumber < shuffleNodesMax && requiredShuffleServerNumber > 0) {
            expectedShuffleNodesNum = requiredShuffleServerNumber;
        }
        if ((servers = this.getRequiredServers(requiredTags, expectedShuffleNodesNum, faultyServerIds)).isEmpty() || servers.size() < replica) {
            return new PartitionRangeAssignment(null);
        }
        SortedMap<PartitionRange, List<ServerNode>> assignments = this.getPartitionAssignment(totalPartitionNum, partitionNumPerRange, replica, servers, estimateTaskConcurrency);
        return new PartitionRangeAssignment(assignments);
    }

    private List<ServerNode> getRequiredServers(Set<String> requiredTags, int expectedNum, Set<String> faultyServerIds) {
        List<ServerNode> servers = this.clusterManager.getServerList(requiredTags, faultyServerIds);
        Collections.shuffle(servers);
        Collections.sort(servers);
        if (expectedNum > servers.size()) {
            LOG.warn("Can't get expected servers [{}] and found only [{}]", (Object)expectedNum, (Object)servers.size());
            return servers;
        }
        return this.getCandidateNodes(servers, expectedNum);
    }
}

