/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shuffle.manager;

import io.grpc.ServerInterceptor;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.metrics.GRPCMetrics;
import org.apache.uniffle.common.rpc.GrpcServer;
import org.apache.uniffle.common.rpc.ServerType;
import org.apache.uniffle.shuffle.manager.RssShuffleManagerInterface;
import org.apache.uniffle.shuffle.manager.ShuffleManagerGrpcService;

public class ShuffleManagerServerFactory {
    private final RssShuffleManagerInterface shuffleManager;
    private final RssBaseConf conf;

    public ShuffleManagerServerFactory(RssShuffleManagerInterface shuffleManager, RssConf conf) {
        this.shuffleManager = shuffleManager;
        this.conf = new RssBaseConf();
        this.conf.addAll(conf);
    }

    public ShuffleManagerGrpcService getService() {
        return new ShuffleManagerGrpcService(this.shuffleManager);
    }

    public GrpcServer getServer() {
        return this.getServer(null);
    }

    public GrpcServer getServer(ShuffleManagerGrpcService service) {
        ServerType type = this.conf.get(RssBaseConf.RPC_SERVER_TYPE);
        if (type == ServerType.GRPC || type == ServerType.GRPC_NETTY) {
            if (service == null) {
                service = new ShuffleManagerGrpcService(this.shuffleManager);
            }
            return GrpcServer.Builder.newBuilder().conf(this.conf).grpcMetrics(GRPCMetrics.getEmptyGRPCMetrics(this.conf)).addService(service, new ServerInterceptor[0]).build();
        }
        throw new UnsupportedOperationException("Unsupported server type " + (Object)((Object)type));
    }

    public RssBaseConf getConf() {
        return this.conf;
    }
}

