/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.buffer;

import java.nio.ByteBuffer;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.io.netty.buffer.ByteBuf;
import org.apache.uniffle.io.netty.buffer.Unpooled;

public class NettyManagedBuffer
extends ManagedBuffer {
    public static final NettyManagedBuffer EMPTY_BUFFER = new NettyManagedBuffer(Unpooled.EMPTY_BUFFER);
    private ByteBuf buf;

    public NettyManagedBuffer(ByteBuf byteBuf) {
        this.buf = byteBuf;
    }

    @Override
    public int size() {
        return this.buf.readableBytes();
    }

    @Override
    public ByteBuf byteBuf() {
        return Unpooled.wrappedBuffer(this.nioByteBuffer());
    }

    @Override
    public ByteBuffer nioByteBuffer() {
        return this.buf.nioBuffer();
    }

    @Override
    public ManagedBuffer retain() {
        this.buf.retain();
        return this;
    }

    @Override
    public ManagedBuffer release() {
        this.buf.release();
        return this;
    }

    @Override
    public Object convertToNetty() {
        return this.buf.duplicate().retain();
    }
}

