/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.common;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.common.storage.StorageMedia;
import org.apache.uniffle.storage.common.StorageMediaProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStorageMediaProvider
implements StorageMediaProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStorageMediaProvider.class);
    private static final String NUMBERIC_STRING = "0123456789";
    private static final String BLOCK_PATH_FORMAT = "/sys/block/%s/queue/rotational";
    private static final String HDFS = "hdfs";
    private static final List<String> OBJECT_STORE_SCHEMAS = Arrays.asList("s3", "oss", "cos", "gcs", "obs", "daos");

    @Override
    public StorageMedia getStorageMediaFor(String baseDir) {
        try {
            URI uri = new URI(baseDir);
            String scheme = uri.getScheme();
            if (HDFS.equals(scheme)) {
                return StorageMedia.HDFS;
            }
            if (scheme != null && OBJECT_STORE_SCHEMAS.contains(scheme.toLowerCase())) {
                return StorageMedia.OBJECT_STORE;
            }
        }
        catch (URISyntaxException e) {
            logger.warn("invalid uri input from " + baseDir + ", with exception:", (Throwable)e);
        }
        if (SystemUtils.IS_OS_LINUX) {
            try {
                List<String> contents;
                File baseFile = new File(baseDir);
                FileStore store = this.getFileStore(baseFile.toPath());
                if (store == null) {
                    throw new IOException("Can't get FileStore for path:" + baseFile.getAbsolutePath());
                }
                String deviceName = DefaultStorageMediaProvider.getDeviceName(store.name());
                File blockFile = new File(String.format(BLOCK_PATH_FORMAT, deviceName));
                if (blockFile.exists() && (contents = Files.readAllLines(blockFile.toPath())).size() >= 1) {
                    String rotational = contents.get(0);
                    if (rotational.equals("0")) {
                        return StorageMedia.SSD;
                    }
                    if (rotational.equals("1")) {
                        return StorageMedia.HDD;
                    }
                }
            }
            catch (IOException ioe) {
                logger.warn("Get storage type failed with exception", (Throwable)ioe);
            }
        }
        logger.info("Default storage type provider returns HDD by default");
        return StorageMedia.HDD;
    }

    @VisibleForTesting
    FileStore getFileStore(Path path) throws IOException {
        while (!Files.exists(path, new LinkOption[0])) {
            if ((path = path.getParent()) != null) continue;
            return null;
        }
        return Files.getFileStore(path);
    }

    @VisibleForTesting
    static String getDeviceName(String mountPoint) {
        int separatorIndex = mountPoint.lastIndexOf(File.separator);
        String deviceName = separatorIndex > -1 ? mountPoint.substring(separatorIndex + 1) : mountPoint;
        return StringUtils.stripEnd((String)deviceName, (String)NUMBERIC_STRING);
    }
}

