/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.org.roaringbitmap;

import org.apache.uniffle.org.roaringbitmap.BatchIterator;
import org.apache.uniffle.org.roaringbitmap.IntIterator;

public class BatchIntIterator
implements IntIterator {
    private int i;
    private int mark;
    private int[] buffer;
    private BatchIterator delegate;

    private BatchIntIterator(BatchIterator delegate, int i, int mark, int[] buffer) {
        this.delegate = delegate;
        this.i = i;
        this.mark = mark;
        this.buffer = buffer;
    }

    BatchIntIterator(BatchIterator delegate, int[] buffer) {
        this(delegate, 0, -1, buffer);
    }

    @Override
    public boolean hasNext() {
        if (this.i < this.mark) {
            return true;
        }
        if (!this.delegate.hasNext() || (this.mark = this.delegate.nextBatch(this.buffer)) == 0) {
            return false;
        }
        this.i = 0;
        return true;
    }

    @Override
    public int next() {
        return this.buffer[this.i++];
    }

    @Override
    public IntIterator clone() {
        try {
            BatchIntIterator it = (BatchIntIterator)super.clone();
            it.delegate = this.delegate.clone();
            it.buffer = (int[])this.buffer.clone();
            return it;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

