/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.uniffle.client.impl.TrackingBlockStatus;
import org.apache.uniffle.com.google.common.collect.Lists;
import org.apache.uniffle.com.google.common.collect.Maps;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.rpc.StatusCode;

public class FailedBlockSendTracker {
    private Map<Long, List<TrackingBlockStatus>> trackingBlockStatusMap = Maps.newConcurrentMap();

    public void add(ShuffleBlockInfo shuffleBlockInfo, ShuffleServerInfo shuffleServerInfo, StatusCode statusCode) {
        this.trackingBlockStatusMap.computeIfAbsent(shuffleBlockInfo.getBlockId(), s -> Lists.newLinkedList()).add(new TrackingBlockStatus(shuffleBlockInfo, shuffleServerInfo, statusCode));
    }

    public void merge(FailedBlockSendTracker failedBlockSendTracker) {
        this.trackingBlockStatusMap.putAll(failedBlockSendTracker.trackingBlockStatusMap);
    }

    public void remove(long blockId) {
        this.trackingBlockStatusMap.remove(blockId);
    }

    public void clearAndReleaseBlockResources() {
        this.trackingBlockStatusMap.values().stream().flatMap(x -> x.stream()).forEach(x -> x.getShuffleBlockInfo().executeCompletionCallback(true));
        this.trackingBlockStatusMap.clear();
    }

    public Set<Long> getFailedBlockIds() {
        return this.trackingBlockStatusMap.keySet();
    }

    public List<TrackingBlockStatus> getFailedBlockStatus(Long blockId) {
        return this.trackingBlockStatusMap.get(blockId);
    }

    public Set<ShuffleServerInfo> getFaultyShuffleServers() {
        return this.trackingBlockStatusMap.values().stream().flatMap(Collection::stream).map(s -> s.getShuffleServerInfo()).collect(Collectors.toSet());
    }
}

