/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.common;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.storage.StorageMedia;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.storage.common.AbstractStorage;
import org.apache.uniffle.storage.common.LocalStorageMeta;
import org.apache.uniffle.storage.common.StorageReadMetrics;
import org.apache.uniffle.storage.common.StorageWriteMetrics;
import org.apache.uniffle.storage.handler.api.ServerReadHandler;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.apache.uniffle.storage.handler.impl.LocalFileServerReadHandler;
import org.apache.uniffle.storage.handler.impl.LocalFileWriteHandler;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.apache.uniffle.storage.request.CreateShuffleWriteHandlerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorage
extends AbstractStorage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalStorage.class);
    public static final String STORAGE_HOST = "local";
    private final long diskCapacity;
    private volatile long diskAvailableBytes;
    private volatile long serviceUsedBytes;
    private boolean enableDiskCapacityCheck = false;
    private long capacity;
    private final String basePath;
    private final String mountPoint;
    private final double highWaterMarkOfWrite;
    private final double lowWaterMarkOfWrite;
    private final LocalStorageMeta metaData = new LocalStorageMeta();
    private final StorageMedia media;
    private boolean isSpaceEnough = true;
    private volatile boolean isCorrupted = false;

    private LocalStorage(Builder builder) {
        this.basePath = builder.basePath;
        this.highWaterMarkOfWrite = builder.highWaterMarkOfWrite;
        this.lowWaterMarkOfWrite = builder.lowWaterMarkOfWrite;
        this.capacity = builder.capacity;
        this.media = builder.media;
        this.enableDiskCapacityCheck = builder.enableDiskCapacityWatermarkCheck;
        File baseFolder = new File(this.basePath);
        try {
            FileUtils.forceMkdir((File)baseFolder);
            FileUtils.cleanDirectory((File)baseFolder);
            FileStore store = Files.getFileStore(baseFolder.toPath());
            this.mountPoint = store.name();
        }
        catch (IOException ioe) {
            LOG.warn("Init base directory " + this.basePath + " fail, the disk should be corrupted", (Throwable)ioe);
            throw new RssException((Throwable)ioe);
        }
        this.diskCapacity = baseFolder.getTotalSpace();
        this.diskAvailableBytes = baseFolder.getUsableSpace();
        if (this.capacity < 0L) {
            this.capacity = (long)((double)this.diskCapacity * builder.ratio);
            LOG.info("The `rss.server.disk.capacity` is not specified nor negative, the ratio(`rss.server.disk.capacity.ratio`:{}) * disk space({}) is used, ", (Object)builder.ratio, (Object)this.diskCapacity);
        } else {
            long freeSpace = this.diskAvailableBytes;
            if (freeSpace < this.capacity) {
                throw new IllegalArgumentException("The Disk of " + this.basePath + " Available Capacity " + freeSpace + " is smaller than configuration");
            }
        }
    }

    @Override
    public String getStoragePath() {
        return this.basePath;
    }

    @Override
    public String getStorageHost() {
        return STORAGE_HOST;
    }

    @Override
    public void updateWriteMetrics(StorageWriteMetrics metrics) {
        this.updateWrite(RssUtils.generateShuffleKey((String)metrics.getAppId(), (int)metrics.getShuffleId()), metrics.getDataSize(), metrics.getPartitions());
    }

    @Override
    public void updateReadMetrics(StorageReadMetrics metrics) {
        String shuffleKey = RssUtils.generateShuffleKey((String)metrics.getAppId(), (int)metrics.getShuffleId());
        this.prepareStartRead(shuffleKey);
        this.updateShuffleLastReadTs(shuffleKey);
    }

    @Override
    ShuffleWriteHandler newWriteHandler(CreateShuffleWriteHandlerRequest request) {
        return new LocalFileWriteHandler(request.getAppId(), request.getShuffleId(), request.getStartPartition(), request.getEndPartition(), this.basePath, request.getFileNamePrefix());
    }

    @Override
    protected ServerReadHandler newReadHandler(CreateShuffleReadHandlerRequest request) {
        return new LocalFileServerReadHandler(request.getAppId(), request.getShuffleId(), request.getPartitionId(), request.getPartitionNumPerRange(), request.getPartitionNum(), this.basePath);
    }

    @VisibleForTesting
    public void enableDiskCapacityCheck() {
        this.enableDiskCapacityCheck = true;
    }

    public long getDiskCapacity() {
        return this.diskCapacity;
    }

    @Override
    public boolean canWrite() {
        boolean diskUsedCapacityCheck;
        boolean serviceUsedCapacityCheck;
        if (this.isSpaceEnough) {
            serviceUsedCapacityCheck = (double)(this.serviceUsedBytes * 100L) / (double)this.capacity < this.highWaterMarkOfWrite;
            diskUsedCapacityCheck = (double)(this.diskCapacity - this.diskAvailableBytes) * 100.0 / (double)this.diskCapacity < this.highWaterMarkOfWrite;
        } else {
            serviceUsedCapacityCheck = (double)(this.serviceUsedBytes * 100L) / (double)this.capacity < this.lowWaterMarkOfWrite;
            diskUsedCapacityCheck = (double)(this.diskCapacity - this.diskAvailableBytes) * 100.0 / (double)this.diskCapacity < this.lowWaterMarkOfWrite;
        }
        this.isSpaceEnough = serviceUsedCapacityCheck && (!this.enableDiskCapacityCheck || diskUsedCapacityCheck);
        return this.isSpaceEnough && !this.isCorrupted;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void createMetadataIfNotExist(String shuffleKey) {
        this.metaData.createMetadataIfNotExist(shuffleKey);
    }

    public void updateWrite(String shuffleKey, long delta, List<Integer> partitionList) {
        this.metaData.updateDiskSize(delta);
        this.metaData.addShufflePartitionList(shuffleKey, partitionList);
        this.metaData.updateShuffleSize(shuffleKey, delta);
    }

    public void prepareStartRead(String key) {
        this.metaData.prepareStartRead(key);
    }

    public void updateShuffleLastReadTs(String shuffleKey) {
        this.metaData.updateShuffleLastReadTs(shuffleKey);
    }

    @VisibleForTesting
    public LocalStorageMeta getMetaData() {
        return this.metaData;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public StorageMedia getStorageMedia() {
        return this.media;
    }

    public void removeResources(String shuffleKey) {
        LOG.info("Start to remove resource of {}", (Object)shuffleKey);
        try {
            this.metaData.updateDiskSize(-this.metaData.getShuffleSize(shuffleKey));
            this.metaData.removeShuffle(shuffleKey);
            LOG.info("Finish remove resource of {}, disk size is {} and {} shuffle metadata", new Object[]{shuffleKey, this.metaData.getDiskSize(), this.metaData.getShuffleMetaSet().size()});
        }
        catch (Exception e) {
            LOG.error("Fail to update disk size", (Throwable)e);
        }
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    public void markCorrupted() {
        this.isCorrupted = true;
    }

    public Set<String> getAppIds() {
        HashSet<String> appIds = new HashSet<String>();
        File baseFolder = new File(this.basePath);
        File[] files = baseFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || file.isHidden()) continue;
                appIds.add(file.getName());
            }
        }
        return appIds;
    }

    public void updateDiskAvailableBytes(long bytes) {
        this.diskAvailableBytes = bytes;
    }

    public void updateServiceUsedBytes(long usedBytes) {
        this.serviceUsedBytes = usedBytes;
    }

    public long getServiceUsedBytes() {
        return this.serviceUsedBytes;
    }

    @VisibleForTesting
    public void markSpaceFull() {
        this.isSpaceEnough = false;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long capacity;
        private double ratio;
        private double lowWaterMarkOfWrite;
        private double highWaterMarkOfWrite;
        private String basePath;
        private StorageMedia media;
        private boolean enableDiskCapacityWatermarkCheck;

        private Builder() {
        }

        public Builder capacity(long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder ratio(double ratio) {
            this.ratio = ratio;
            return this;
        }

        public Builder lowWaterMarkOfWrite(double lowWaterMarkOfWrite) {
            this.lowWaterMarkOfWrite = lowWaterMarkOfWrite;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder highWaterMarkOfWrite(double highWaterMarkOfWrite) {
            this.highWaterMarkOfWrite = highWaterMarkOfWrite;
            return this;
        }

        public Builder localStorageMedia(StorageMedia media) {
            this.media = media;
            return this;
        }

        public Builder enableDiskCapacityWatermarkCheck() {
            this.enableDiskCapacityWatermarkCheck = true;
            return this;
        }

        public LocalStorage build() {
            return new LocalStorage(this);
        }
    }
}

