/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.dashboard.web.proxy;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebProxyServlet
extends ProxyServlet {
    private String targetAddress;
    private static final Logger LOG = LoggerFactory.getLogger(WebProxyServlet.class);

    public WebProxyServlet(String targetAddress) {
        this.targetAddress = targetAddress;
    }

    protected String rewriteTarget(HttpServletRequest clientRequest) {
        if (!this.validateDestination(clientRequest.getServerName(), clientRequest.getServerPort())) {
            return null;
        }
        StringBuilder target = new StringBuilder();
        if (this.targetAddress.endsWith("/")) {
            this.targetAddress = this.targetAddress.substring(0, this.targetAddress.length() - 1);
        }
        target.append(this.targetAddress).append("/api").append(clientRequest.getPathInfo());
        String query = clientRequest.getQueryString();
        if (query != null) {
            target.append("?").append(query);
        }
        return target.toString();
    }

    protected void onProxyRewriteFailed(HttpServletRequest clientRequest, HttpServletResponse clientResponse) {
    }

    protected void onProxyResponseFailure(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Response serverResponse, Throwable failure) {
    }

    protected String filterServerResponseHeader(HttpServletRequest clientRequest, Response serverResponse, String headerName, String headerValue) {
        return null;
    }

    protected void addXForwardedHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
    }
}

