/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;

public class GetLocalShuffleDataResponse
extends RpcResponse {
    public GetLocalShuffleDataResponse(long requestId, StatusCode statusCode, String retMessage, ManagedBuffer data) {
        super(requestId, statusCode, retMessage, data);
    }

    public static GetLocalShuffleDataResponse decode(ByteBuf byteBuf, boolean decodeBody) {
        long requestId = byteBuf.readLong();
        StatusCode statusCode = StatusCode.fromCode(byteBuf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(byteBuf);
        if (decodeBody) {
            NettyManagedBuffer nettyManagedBuffer = new NettyManagedBuffer(byteBuf);
            return new GetLocalShuffleDataResponse(requestId, statusCode, retMessage, nettyManagedBuffer);
        }
        return new GetLocalShuffleDataResponse(requestId, statusCode, retMessage, NettyManagedBuffer.EMPTY_BUFFER);
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_LOCAL_SHUFFLE_DATA_RESPONSE;
    }
}

