/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StopWatch;
import org.apache.uniffle.com.google.common.collect.Lists;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.common.config.RssConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmPauseMonitor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JvmPauseMonitor.class);
    private static final long SLEEP_INTERVAL_MS = 500L;
    private long warnThresholdMs;
    private static final String WARN_THRESHOLD_KEY = "jvm.pause.warn-threshold.ms";
    private static final long WARN_THRESHOLD_DEFAULT = 10000L;
    private long infoThresholdMs;
    private static final String INFO_THRESHOLD_KEY = "jvm.pause.info-threshold.ms";
    private static final long INFO_THRESHOLD_DEFAULT = 1000L;
    private long numGcWarnThresholdExceeded = 0L;
    private long numGcInfoThresholdExceeded = 0L;
    private long totalGcExtraSleepTime = 0L;
    private Thread monitorThread;
    private volatile boolean shouldRun = true;

    public JvmPauseMonitor(RssConf rssConf) {
        this.warnThresholdMs = rssConf.getLong(WARN_THRESHOLD_KEY, 10000L);
        this.infoThresholdMs = rssConf.getLong(INFO_THRESHOLD_KEY, 1000L);
    }

    public void start() {
        this.monitorThread = new Daemon((Runnable)new Monitor());
        this.monitorThread.start();
    }

    public boolean isStarted() {
        return this.monitorThread != null;
    }

    public long getNumGcWarnThresholdExceeded() {
        return this.numGcWarnThresholdExceeded;
    }

    public long getNumGcInfoThresholdExceeded() {
        return this.numGcInfoThresholdExceeded;
    }

    public long getTotalGcExtraSleepTime() {
        return this.totalGcExtraSleepTime;
    }

    private String formatMessage(long extraSleepTime, Map<String, GcTimes> gcTimesAfterSleep, Map<String, GcTimes> gcTimesBeforeSleep) {
        Sets.SetView<String> gcBeanNames = Sets.intersection(gcTimesAfterSleep.keySet(), gcTimesBeforeSleep.keySet());
        ArrayList<String> gcDiffs = Lists.newArrayList();
        for (String name : gcBeanNames) {
            GcTimes diff = gcTimesAfterSleep.get(name).subtract(gcTimesBeforeSleep.get(name));
            if (diff.gcCount == 0L) continue;
            gcDiffs.add("GC pool '" + name + "' had collection(s): " + diff.toString());
        }
        String ret = "Detected pause in JVM or host machine (eg GC): pause of approximately " + extraSleepTime + "ms\n";
        ret = gcDiffs.isEmpty() ? ret + "No GCs detected" : ret + StringUtils.join(gcDiffs, (String)"\n");
        return ret;
    }

    private Map<String, GcTimes> getGcTimes() {
        HashMap<String, GcTimes> map = new HashMap<String, GcTimes>();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            map.put(gcBean.getName(), new GcTimes(gcBean));
        }
        return map;
    }

    @Override
    public void close() throws IOException {
        this.shouldRun = false;
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
            try {
                this.monitorThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        JvmPauseMonitor monitor = new JvmPauseMonitor(new RssConf());
        monitor.start();
        ArrayList<String> list = Lists.newArrayList();
        int i = 0;
        while (true) {
            list.add(String.valueOf(i++));
        }
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        @Override
        public void run() {
            StopWatch sw = new StopWatch();
            Map gcTimesBeforeSleep = JvmPauseMonitor.this.getGcTimes();
            LOG.info("Starting JVM pause monitor");
            while (JvmPauseMonitor.this.shouldRun) {
                sw.reset().start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    return;
                }
                long extraSleepTime = sw.now(TimeUnit.MILLISECONDS) - 500L;
                Map gcTimesAfterSleep = JvmPauseMonitor.this.getGcTimes();
                if (extraSleepTime > JvmPauseMonitor.this.warnThresholdMs) {
                    ++JvmPauseMonitor.this.numGcWarnThresholdExceeded;
                    LOG.warn(JvmPauseMonitor.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                } else if (extraSleepTime > JvmPauseMonitor.this.infoThresholdMs) {
                    ++JvmPauseMonitor.this.numGcInfoThresholdExceeded;
                    LOG.info(JvmPauseMonitor.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                }
                JvmPauseMonitor.this.totalGcExtraSleepTime = JvmPauseMonitor.this.totalGcExtraSleepTime + extraSleepTime;
                gcTimesBeforeSleep = gcTimesAfterSleep;
            }
        }
    }

    private static class GcTimes {
        private long gcCount;
        private long gcTimeMillis;

        private GcTimes(GarbageCollectorMXBean gcBean) {
            this.gcCount = gcBean.getCollectionCount();
            this.gcTimeMillis = gcBean.getCollectionTime();
        }

        private GcTimes(long count, long time) {
            this.gcCount = count;
            this.gcTimeMillis = time;
        }

        private GcTimes subtract(GcTimes other) {
            return new GcTimes(this.gcCount - other.gcCount, this.gcTimeMillis - other.gcTimeMillis);
        }

        public String toString() {
            return "count=" + this.gcCount + " time=" + this.gcTimeMillis + "ms";
        }
    }
}

